; Microsoft Powerpoint 97 and 2000 Script file for
; JFW 3.31 Copyright (c) 1998-1999 Henter-Joyce Inc.
; Written by Joseph K Stephen (formerly Dunn)
; Build: PP3312730 last modified on 1 October 1999 
; note the term shape is synonymous with object. Powerpoint refers to shapes but a shape is a particular class of object.

include "hjglobal.jsh"
Include "hjconst.jsh" ; constants for attributes, window class
include "powerpnt.jsh"
include "powerpnt.jsm"


int Function GetPptVersion ()
return (GetProgramVersion (GetAppFilePath ()) >=8)
EndFunction

Object Function GetPptAppObj ()
; OPpt is a global
if !oPpt then
	let oPpt = MSOGetMenuBarObject ();
	let oPpt = oPpt.Application; init pointer to Powerpoint app object
endIf
if !oPpt then
; attempt to get it
	let oPpt=getObject(appObjName)
endIf
if !oPpt then
say(msgPleaseWait,ot_message)
	let oPpt=createObject(appObjName)
	say(msgReady,ot_message)
endIf
EndFunction

Function AutoStartEvent ()
if (HasRunBefore == false) then
	let HasRunBefore = true
	if (GetVerbosity() == beginner) then
 SayExtendedHelpHotKey ()
		say(msg1,ot_help) ;"Use Insert plus the letter H for help in various dialog boxes"
	EndIf
	let globalTableReadingMethod=tableRowByRow 
	let globalParaIndexPointer=0 ; for tracking which animated paragraph we are up to
	let globalShapeIndex=1
	let globalPriorSlideIndex=0
EndIf
; set mouse pixel movement to 1 pixel for better accuracy.
let GlobalMousePixel=1
GetPptAppObj()
EndFunction

Script SayPowerpointVersion ()
if GetProgramVersion (GetAppFilePath ()) ==8 then
	say(msg2, ot_status) ; Powerpoint 97
elif GetProgramVersion (GetAppFilePath ()) ==9 then
	say(msg3,ot_status) ; Powerpoint 2000
else
	say(msg3a,ot_status) ; version prior to 97, unsupported by JFW. 
endIf
EndScript

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
int TheControlId,
	string TheClass

let theControlId=GetControlId(hwnd)
let TheClass = GetWindowClass(hwnd)
if TheControlId==MispelledWordId && GetWindowName(GetRealWindow(hwnd))==SpellingDlgTitle then
  PerformScript Spellcheck()
  return
endIf
if (GetScreenEcho() > 1)
   ;wc4="#32771"
   || (TheClass == wc4)  ||
; wc3=static, AutoContentWizDlgTitle="AutoContent Wizard" 
  (theClass==wc3 && GetWindowName(GetRealWindow(hwnd))==AutoContentWizDlgTitle) then
	say(buffer, ot_buffer)
; wc5="officeTooltip"
elif theClass==wc5 && isJawsCursor() then
  say(buffer, ot_buffer)
  say(msg15, ot_help) ; tooltip
EndIf
EndFunction

Void Function SayHighLightedText (handle hwnd, string buffer)
if GetWindowClass (GetFocus ())=="MSOCommandBar"
then return
endif

if PptSuppressEcho then
  let PptSuppressEcho=false
  return
endIf
if GetWindowClass(hwnd)=="PP97FrameClass" then
  return ;ignore highlighting
endIf
if(GetScreenEcho() > 0) Then
	say(buffer, ot_buffer)
EndIf
EndFunction

Script SpellCheck ()
If (GetWindowName (GetRealWindow(GetCurrentWindow())) == SpellingDlgTitle) Then
RouteInvisibleToPc()
InvisibleCursor()
JawsPageUp()
NextLine()
JawsEnd()
If (GetVerbosity () > beginner) then
SayWord ()
Else
SayLine ()
EndIf
SpellWord() ;spell it either way
NextLine()
JawsEnd ()
If (GetVerbosity () > 0) then
SayWord ()
Else
SayLine()
EndIf
SpellWord() ;spell it either way
PcCursor()
Else
say (msg421, ot_status) ;"Not in spellchecker"
EndIf
EndScript

Script  ScriptFileName()
ScriptAndAppNames("PowerPoint")
EndScript

Void Function SayNewSlideType ()
; by Marco Zehe and Joseph K Stephen. 
; assumes we are in the new slide dialog and focus is on the control with class UserControl
var
int OldGraphicVerbosity,
handle hwnd

; don't want to speak graphics, just text description.
  let OldGraphicVerbosity=GetJcfOption(opt_Include_Graphics)
  setJcfOption(opt_include_Graphics,0) ; speak none
let hwnd = GetRealWindow(GetFocus())
let hwnd = FindDescendantWindow (hwnd, FillTypeMenuID)
if hwnd Then
	SayWindow (hwnd, Read_Everything)
EndIf
setJcfOption(opt_Include_Graphics, oldGraphicVerbosity)
EndFunction

Function SayUserControl ()
var
int CId,
string Name,
string class
let class=GetWindowClass(getFocus())
let name=getWindowName(getParent(GetFocus()))
let CId=getControlId(GetFocus())
if not isPcCursor() then
	sayWord()
return
endIf
if class !=wc2 then
  return
endIf
if name==NewSlideDlgTitle || name==SlideLayoutDlgTitle then
  sayNewSlideType()
elif name==BulletDlgTitle then
  if CId==BulletColorMenuId then
    say(msg350, ot_help) ; color menu
     {down arrow} ; activate menu control
    Pause()
    sayLine()
  elif CId==BulletTypeId then
    if GetVerbosity()==beginner then
      say(msg351, ot_help) ; bullet type
    endIf
    SayWord()
  endIf 
elif name==BackgroundDlgTitle then
  if CId==FillTypeMenuId then
    say(msg350a,ot_help) ; fill type menu
     {down arrow} ; activate menu control
    Pause()
    sayLine()
  EndIf
elif name==ColorSchemeDlgTitle then
say(msg418, ot_help)
elif name==SetupShowDlgTitle &&cId==PenId then
	say(msg331,ot_help)
	{down arrow}
	pause()
	sayLine()
endIf
EndFunction

int Function isSlideShow ()
return (oPpt.activePresentation.slideShowWindow.view.state==ppSlideShowRunning)
EndFunction

int Function isSlideShowDone ()
return oPpt.activePresentation.slideShowWindow.view.state==ppSlideShowDone
EndFunction

int Function getShowElapsedTime ()
return oPpt.activePresentation.slideShowWindow.view.presentationElapsedTime
EndFunction

int Function detectSlideShowStart ()
; If a slide show has just started then we need to set up JFW to track animated paragraphs.
if isSlideShow() && (getShowElapsedTime()==0) then
	return true
else
	return false
endIf
EndFunction

void Function SayFocusedWindow ()
var
handle focus,
int FocusId,
handle parent,
string ParentName,
string focusClass,
string parentClass

let PptFocusChangeCalled=true
let focus=getFocus()
let FocusId=GetControlId(focus)
let parent=GetParent(focus)
let focusClass=getWindowClass(focus)
let parentClass=getWindowClass(parent)
let ParentName=getWindowName(parent)
if detectSlideShowStart() then
	let globalParaIndexPointer=0
	let globalShapeIndex=1
	let lastParaSpokenIndex=0
	let lastShapeSpokenIndex=0
	let globalPriorSlideIndex=0
	readSlideShowSlide(showAdvance,true)
	return
elif isSlideShow() then
	readSlideShowSlide(showAdvance,true)
	return
endIf
if focusId==ChangeToId && GetWindowName(GetRealWindow(focus))==SpellingDlgTitle then
	PerformScript Spellcheck()
	return
elif focusClass==wc2 then
	SayUserControl()
elif focusClass==wc6 || focusClass==wc7 then
; check if in edit mode.
	if oPPt.activeWindow.selection.type==ppSelectionText then
		say(msg592, ot_message) ; edit
		sayLine()
	else
		performScript SaySelectedObject()   
	endIf
else
	SayObjectTypeAndText()
endIf
EndFunction

Script SayWindowPromptAndText ()
sayFocusedWindow()
EndScript

Script sayPriorLine ()
if GetWindowClass(getFocus())==wc2 then
	priorLine()
	sayUserControl()
elif GetWindowClass(GetFocus())==wc7 then
	priorLine()
; excel worksheet
	SaySelectedShape()
; wc6="paneClassDC"
elif GetWindowClass(GetFocus())==wc6 then
	priorLine()
	if (not isPcCursor()) ||
		caretVisible() ||
		(getCharacterAttributes() & attrib_highlight) then
		sayLine()
	else
		performScript saySelectedObject()
	endIf
else
	performScript sayPriorLine() ; default
endIf
EndScript

Script sayNextLine ()
if GetWindowClass(getFocus())==wc2 then
	nextLine()
	sayUserControl()
elif GetWindowClass(GetFocus())==wc7 then
	nextLine()
; excel worksheet
	SaySelectedShape()
; wc6="paneClassDC"
elif GetWindowClass(GetFocus())==wc6 then
	nextLine()
	if (not isPcCursor()) ||
		caretVisible() ||
		(getCharacterAttributes() & attrib_highlight) then
		sayLine()
	else
		performScript saySelectedObject()
	endIf
else
	performScript sayNextLine() ; default
endIf
EndScript

Script sayLine ()
if GetWindowClass(getFocus())==wc2 then
	sayUserControl()
elif GetWindowClass(GetFocus())==wc7 then
; excel worksheet
	SaySelectedShape()
; wc6="paneClassDC"
elif GetWindowClass(GetFocus())==wc6 then
	if (not isPcCursor()) ||
		caretVisible() ||
		(getCharacterAttributes() & attrib_highlight) then
		sayLine()
	else
		performScript saySelectedObject()
	endIf
else
	performScript sayLine() ; default
endIf
EndScript

Script SayPriorCharacter ()
if GetWindowClass(GetFocus())==wc7 then
	priorCharacter()
	saySelectedShape()
elif GetWindowClass(GetFocus())==wc2 then
	priorCharacter()
	SayUserControl()
; wc6="PaneClassDC"
elif getWindowClass(getFocus())==wc6 then
	priorCharacter()
	if (not isPCCursor()) ||
		caretVisible() ||
		(GetCharacterAttributes() & attrib_highlight) then
		sayCharacter() ; default 
	else
		performScript saySelectedObject()
	endIf
else
	performScript sayPriorcharacter()
endIf
EndScript

Script sayWord ()
if GetWindowClass(GetFocus())==wc7 then
	saySelectedShape()
elif GetWindowClass(GetFocus())==wc2 then
	SayUserControl()
; wc6="PaneClassDC"
elif getWindowClass(getFocus())==wc6 then
	if (not isPCCursor()) ||
		caretVisible() ||
		(GetCharacterAttributes() & attrib_highlight) then
		If (IsSameScript ()) Then
			SpellWord()
			AddHook (HK_SCRIPT, "SpellWordHook")
			return
		else
			sayWord() ; default 
		endIf
	else
		performScript saySelectedObject()
	endIf
else
	performScript sayWord() ; default
endIf
EndScript

Script sayCharacter ()
if (IsSameScript ()) then
	SayCharacterPhonetic ()
	AddHook (HK_SCRIPT, "PhoneticSpellHook")
	return
endIf
if GetWindowClass(GetFocus())==wc7 then
	saySelectedShape()
elif GetWindowClass(GetFocus())==wc2 then
	SayUserControl()
; wc6="PaneClassDC"
elif getWindowClass(getFocus())==wc6 then
	if (not isPCCursor()) ||
		caretVisible() ||
		(GetCharacterAttributes() & attrib_highlight) then
		sayCharacter() ; default 
	else
		performScript saySelectedObject()
	endIf
else
	performScript sayCharacter() ; default
endIf
EndScript

Script SayNextCharacter ()
if GetWindowClass(GetFocus())==wc7 then
	nextCharacter()
	saySelectedShape()
elif GetWindowClass(GetFocus())==wc2 then
	nextCharacter()
	SayUserControl()
; wc6="PaneClassDC"
elif getWindowClass(getFocus())==wc6 then
	nextCharacter()
	if (not isPCCursor()) ||
		caretVisible() ||
		(GetCharacterAttributes() & attrib_highlight) then
		sayCharacter() ; default 
	else
		performScript saySelectedObject()
	endIf
else
	performScript sayNextcharacter()
endIf
endScript

Void Function SaySlideShowPointerType ()
var
int Pointer
let pointer=oPpt.activePresentation.SlideShowWindow.view.pointerType()
if GetVerbosity()==beginner then
  say(msg10,ot_help) ; "Pointer type:"
endIf
if pointer==PointerAlwaysHidden then
  say(msg11,ot_status) ; "always hidden"
elif pointer==PointerArrow then
  say(msg12,ot_status) ; "Arrow"
elif pointer==PointerNone then
  say(msg13,ot_status) ; none
elif pointer==PointerPen then
  say(msg14,ot_status) ; "pen"
endIf
EndFunction

Void Function SaySlideShowState ()
var
int state
let state=oPpt.activePresentation.slideShowWindow.view.state()
if state==0 then
  say(msg4,ot_status) ; no slide show active.
endIf
if state==ppSlideShowBlackScreen then
  say(msg5,ot_status) ; "Black screen"
elif state==ppSlideShowDone then
  say(msg6,ot_status) ; "SlideShow done"
elif state==ppSlideShowPaused then
  say(msg7,ot_status) ; "SlideShow paused"
elif state==ppSlideShowRunning then
  say(msg8,ot_status) ; "SlideShow running"
elif state==ppSlideShowWhiteScreen then
  say(msg9,ot_status) ; "White screen"
endIf
EndFunction

Function sayActivePaneView ()
var
int activePaneView ; for normal view
let activePaneView=oPpt.activeWindow.activePane.viewType

if activePaneView==ppViewSlide then
	say(Msg401,ot_status)
elif activePaneView==ppViewNotesPage then
	say(msg403, ot_status)
elif ActivePaneView==ppViewOutline then
	say(msg406, ot_status)
endIf
EndFunction

Function SayPptView ()
var
int ViewType

let viewType=oPpt.activeWindow.viewType()
if ViewType==ppViewSlide then
	say(Msg401,ot_status)
elif ViewType==PPViewSlideMaster then
	say(msg402, ot_status)
elif ViewType==ppViewNotesPage then
	say(msg403, ot_status)
elif ViewType==ppViewHandoutMaster then
	say(msg404, ot_status)
elif ViewType==ppViewNotesMaster then
	say(msg405, ot_status)
elif viewType==ppViewOutline then
	say(msg406, ot_status)
elif ViewType==ppViewSlideSorter then
	say(msg407, ot_status)
elif viewType==ppViewTitleMaster then
	say(msg408, ot_status)
elif viewType==ppViewNormal then
	say(msg408b, ot_status) ; PP 2000 only
	if getVerbosity()==beginner then
		say(msg408c,ot_status) ; the active pane is
	endIf
	sayActivePaneView()
elif ViewType==0 then
	if isSlideShow() then
	  say(msg408a, ot_status) ; Slide Show view. 
		endIf
endIf
EndFunction

String Function ColumnNumberToLetter (int i)
var
	int quotient,
	int remainder1,
	int remainder2
let i = i-1
let quotient = (i)/26
let remainder1 = quotient%27
let remainder2 = i%26
return SubString (alphabet, remainder1 + 1, 1) + " " + SubString (alphabet, remainder2 + 2, 1)
EndFunction

string Function GetExcel97WorksheetCell (object OleObj)
var
string tempStr,
string rowStr,
string colStr,
string ObjName

let objName=OleObj.activeSheet.name()
if ObjName=="" then ; sheet not active
; unable to get active cell details.
  let objName=msg360 ; excel 97 worksheet
  return ObjName
endIf
let tempStr=OleObj.activeCell.text()
if GetVerbosity()==beginner then
  let RowStr=intToString(OleObj.activeCell.row())
let ColStr=ColumnNumberToLetter(OleObj.activeCell.column())
  let tempStr=colStr+rowStr+": "+tempStr
endIf
let ObjName=tempStr
return objName
EndFunction

String Function GetOleObjDescription (object shape)
var
string description,
string ObjName,
object OleObj,
string progId

let OleObj=shape.OleFormat.object.application()
let ProgId=shape.OleFormat.ProgId()
if ProgId==Excel97sheet then
  return GetExcel97WorksheetCell(OleObj) ; excel worksheet cell info
elif progId==Excel97Chart then
  return msg360a ; Excel 97 Chart
elif progId==MsGraphChart8 then
  return msg361 ; Ms Graph 97 chart 
elif progId==PaintPicture then
  return msg362 ; bitmap picture
elif ProgId==MsClipartGallery2 then
  return msg363 ; Ms Clipart
elif progId==word97doc then
  return msg364 ; word 97 document
elif progId==Ppt97Show then
  return msg365 ; Ppt 97 presentation
elif progId==Ppt97Slide then
  return msg365a ; Ppt 97 slide
endIf
if getVerbosity()==beginner then
  let description=msg247+" " ;"embedded OLE object", ; 7,
endIf
let objName=shape.OleFormat.object.name()
if ObjName=="" then
  let ObjName=msg353+progId
endIf
let description=description+objName
return description
EndFunction

String Function GetShapePlaceHolderDescription (object shape)
; assumes shape.type==msoShapeHolder
var
string description,
int placeHolderFormat
let PlaceHolderFormat=shape.placeHolderFormat.type()
if PlaceHolderFormat==ppPlaceholderBitmap then 
	let description=msg81 ; 9,
elif PlaceHolderFormat==ppPlaceholderBody then 
	let description=msg82 ; 2,
elif PlaceHolderFormat==ppPlaceholderCenterTitle then 
	let description=msg83 ; 3,
elif PlaceHolderFormat==ppPlaceholderChart then 
	let description=msg84 ; 8,
elif PlaceHolderFormat==ppPlaceholderDate then 
	let description=msg85 ; 16,
elif PlaceHolderFormat==ppPlaceholderFooter then 
	let description=msg86 ; 15,
elif PlaceHolderFormat==ppPlaceholderHeader then 
	let description=msg87 ; 14,
elif PlaceHolderFormat==ppPlaceholderMediaClip then 
	let description=msg88 ; 10,
;;elif PlaceHolderFormat==ppPlaceholderMixed then 
;	let description=msg89 ; -2, 
elif PlaceHolderFormat==ppPlaceholderObject then 
	let description=msg90 ; 7,
elif PlaceHolderFormat==ppPlaceholderOrgChart then 
	let description=msg91 ; 11,
elif PlaceHolderFormat==ppPlaceholderSlideNumber then 
	let description=msg92 ; 13,
elif PlaceHolderFormat==ppPlaceholderSubtitle then 
	let description=msg93 ; 4,
elif PlaceHolderFormat==ppPlaceholderTable then 
	let description=msg94 ; 12,
elif PlaceHolderFormat==ppPlaceholderTitle then 
	let description=msg95 ; 1,
elif PlaceHolderFormat==ppPlaceholderVerticalBody then 
	let description=msg96 ; 6,
elif PlaceHolderFormat==ppPlaceholderVerticalTitle then 
	let description=msg97 ; 5,
elif PlaceHolderFormat < 0 then
  let description=msg89
endIf
if getVerbosity()==beginner then
	let description=description+msg254 ;"placeholder", ; 14,
endIf
return description
EndFunction

String Function GetAutoshapeDescription (object shape)
var
int type
let type=shape.autoshapeType()
if type==MsoShape16pointStar then
	return msg194
elif type==MsoShape24pointStar then
	return msg195
elif type==MsoShape32pointStar then
	return msg196
elif type==MsoShape4pointStar then
	return msg191
elif type==MsoShape5pointStar then
	return msg192
elif type==MsoShape8pointStar then
	return msg193
elif type==MsoShapeActionBtnBackorPrev then
	return msg229
elif type==MsoShapeActionButtonBeginning then
	return msg231
elif type==MsoShapeActionButtonCustom then
	return msg225
elif type==MsoShapeActionButtonDocument then
	return msg234
elif type==MsoShapeActionButtonEnd then
	return msg232
elif type==MsoShapeActionBtnForwardorNxt then
	return msg230
elif type==MsoShapeActionButtonHelp then
	return msg227
elif type==MsoShapeActionButtonHome then
	return msg226
elif type==MsoShapeActionBtnInfo then
	return msg228
elif type==MsoShapeActionButtonMovie then
	return msg236
elif type==MsoShapeActionButtonReturn then
	return msg233
elif type==MsoShapeActionButtonSound then
	return msg235
elif type==MsoShapeArc then
	return msg125
elif type==MsoShapeBalloon then
	return msg237
elif type==MsoShapeBentArrow then
	return msg141
elif type==MsoShapeBentUpArrow then
	return msg144
elif type==MsoShapeBevel then
	return msg115
elif type==MsoShapeBlockArc then
	return msg120
elif type==MsoShapeCan then
	return msg113
elif type==MsoShapeChevron then
	return msg152
elif type==MsoShapeCircularArrow then
	return msg160
elif type==MsoShapeCloudCallout then
	return msg208
elif type==MsoShapeCross then
	return msg111
elif type==MsoShapeCube then
	return msg114
elif type==MsoShapeCurvedDownArrow then
	return msg148
elif type==MsoShapeCurvedDownRibbon then
	return msg200
elif type==MsoShapeCurvedLeftArrow then
	return msg146
elif type==MsoShapeCurvedRightArrow then
	return msg145
elif type==MsoShapeCurvedUpArrow then
	return msg147
elif type==MsoShapeCurvedUpRibbon then
	return msg199
elif type==MsoShapeDiamond then
	return msg104
elif type==MsoShapeDonut then
	return msg118
elif type==MsoShapeDoubleBrace then
	return msg127
elif type==MsoShapeDoubleBracket then
	return msg126
elif type==MsoShapeDoubleWave then
	return msg204
elif type==MsoShapeDownArrow then
	return msg136
elif type==MsoShapeDownArrowCallout then
	return msg156
elif type==MsoShapeDownRibbon then
	return msg198
elif type==MsoShapeExplosion1 then
	return msg189
elif type==MsoShapeExplosion2 then
	return msg190
elif type==MsoShapeFlowchartAltProcess then
	return msg162
elif type==MsoShapeFlowchartCard then
	return msg175
elif type==MsoShapeFlowchartCollate then
	return msg179
elif type==MsoShapeFlowchartConnector then
	return msg173
elif type==MsoShapeFlowchartData then
	return msg164
elif type==MsoShapeFlowchartDecision then
	return msg163
elif type==MsoShapeFlowchartDelay then
	return msg184
elif type==MsoShapeFlowchartDirAccStorage then
	return msg187
elif type==MsoShapeFlowchartDisplay then
	return msg188
elif type==MsoShapeFlowchartDocument then
	return msg167
elif type==MsoShapeFlowchartExtract then
	return msg181
elif type==MsoShapeFlowchartIntStorage then
	return msg166
elif type==MsoShapeFlowchartMagneticDisk then
	return msg186
elif type==MsoShapeFlowchartManualInput then
	return msg171
elif type==MsoShapeFlowchartManualOp then
	return msg172
elif type==MsoShapeFlowchartMerge then
	return msg182
elif type==MsoShapeFlowchartMultidocument then
	return msg168
elif type==MsoShapeFlowchartOffpageCon then
	return msg174
elif type==MsoShapeFlowchartOr then
	return msg178
elif type==MsoShapeFlowchartPredefProc then
	return msg165
elif type==MsoShapeFlowchartPreparation then
	return msg170
elif type==MsoShapeFlowchartProcess then
	return msg161
elif type==MsoShapeFlowchartPunchedTape then
	return msg176
elif type==MsoShapeFlowchartSeqAccStorage then
	return msg185
elif type==MsoShapeFlowchartSort then
	return msg180
elif type==MsoShapeFlowchartStoredData then
	return msg183
elif type==MsoShapeFlowchartSummingJunct then
	return msg177
elif type==MsoShapeFlowchartTerminator then
	return msg169
elif type==MsoShapeFoldedCorner then
	return msg116
elif type==MsoShapeHeart then
	return msg121
elif type==MsoShapeHexagon then
	return msg110
elif type==MsoShapeHorizontalScroll then
	return msg202
elif type==MsoShapeIsoscelesTriangle then
	return msg107
elif type==MsoShapeLeftArrow then
	return msg134
elif type==MsoShapeLeftArrowCallout then
	return msg154
elif type==MsoShapeLeftBrace then
	return msg131
elif type==MsoShapeLeftBracket then
	return msg129
elif type==MsoShapeLeftRightArrow then
	return msg137
elif type==MsoShapeLeftRightArrowCallout then
	return msg157
elif type==MsoShapeLeftRightUpArrow then
	return msg140
elif type==MsoShapeLeftUpArrow then
	return msg143
elif type==MsoShapeLightningBolt then
	return msg122
elif type==MsoShapeLineCallout1 then
	return msg209
elif type==MsoShapeLineCallout1AccentBar then
	return msg213
elif type==MsoShapeLnCallout1BordAccBar then
	return msg221
elif type==MsoShapeLineCallout1NoBorder then
	return msg217
elif type==MsoShapeLineCallout2 then
	return msg210
elif type==MsoShapeLineCallout2AccentBar then
	return msg214
elif type==MsoShapeLnCallout2BordAccBar then
	return msg222
elif type==MsoShapeLineCallout2NoBorder then
	return msg218
elif type==MsoShapeLineCallout3 then
	return msg211
elif type==MsoShapeLineCallout3AccentBar then
	return msg215
elif type==MsoShapeLnCallout3BordAccBar then
	return msg223
elif type==MsoShapeLineCallout3NoBorder then
	return msg219
elif type==MsoShapeLineCallout4 then
	return msg212
elif type==MsoShapeLineCallout4AccentBar then
	return msg216
elif type==MsoShapeLnCallout4BordAccBar then
	return msg224
elif type==MsoShapeLineCallout4NoBorder then
	return msg220
;elif type==MsoShapeMixed then
;	return msg102m
elif type==MsoShapeMoon then
	return msg124
elif type==MsoShapeNoSymbol then
	return msg119
elif type==MsoShapeNotchedRightArrow then
	return msg150
elif type==MsoShapeNotPrimitive then
	return msg238
elif type==MsoShapeOctagon then
	return msg106
elif type==MsoShapeOval then
	return msg109
elif type==MsoShapeOvalCallout then
	return msg207
elif type==MsoShapeParallelogram then
	return msg102
elif type==MsoShapePentagon then
	return msg151
elif type==MsoShapePlaque then
	return msg128
elif type==MsoShapeQuadArrow then
	return msg139
elif type==MsoShapeQuadArrowCallout then
	return msg159
elif type==MsoShapeRectangle then
	return msg101
elif type==MsoShapeRectangularCallout then
	return msg205
elif type==MsoShapeRegularPentagon then
	return msg112
elif type==MsoShapeRightArrow then
	return msg133
elif type==MsoShapeRightArrowCallout then
	return msg153
elif type==MsoShapeRightBrace then
	return msg132
elif type==MsoShapeRightBracket then
	return msg130
elif type==MsoShapeRightTriangle then
	return msg108
elif type==MsoShapeRoundedRectangle then
	return msg105
elif type==MsoShapeRoundedRectCallout then
	return msg206
elif type==MsoShapeSmileyFace then
	return msg117
elif type==MsoShapeStripedRightArrow then
	return msg149
elif type==MsoShapeSun then
	return msg123
elif type==MsoShapeTrapezoid then
	return msg103
elif type==MsoShapeUpArrow then
	return msg135
elif type==MsoShapeUpArrowCallout then
	return msg155
elif type==MsoShapeUpDownArrow then
	return msg138
elif type==MsoShapeUpDownArrowCallout then
	return msg158
elif type==MsoShapeUpRibbon then
	return msg197
elif type==MsoShapeUTurnArrow then
	return msg142
elif type==MsoShapeVerticalScroll then
	return msg201
 elif type==MsoShapeWave then
	return msg203
else
	return shape.name()
endIf
EndFunction

String Function getTableDimensions (object table)
var
int rowCount,
int columnCount,
string tableDesc,
object cell

let tableDesc=intToString(table.rows.count)
let tableDesc=tableDesc+msg376+msg377
let tableDesc=tableDesc+intToString(table.columns.count)
let tableDesc=tableDesc+msg378
return tableDesc
EndFunction

Void Function readTable (object table, int readingMethod)
var
object cell,
int row,
int col
if readingMethod==tableRowByRow then
; read row by row
	let row=1
	while row <=table.rows.count
		if getVerbosity()==beginner then
			sayUsingVoice(vctx_message,msg376a+intToString(row),ot_message)
		endIf
		let col=1
		while col <=table.columns.count
			let cell=table.cell(row,col)
			if getVerbosity()==beginner then
				sayUsingVoice(vctx_message,msg378a+intToString(col),ot_message) ; col
			endIf
			if cell.shape.hasTextFrame() then
				if cell.shape.textFrame.hasText() then
					say(cell.shape.textFrame.textRange.text,ot_message)
				else
					say(msg21,ot_message)
				endIf
			else
				say(msg21,ot_message)
			endIf
			let col=col+1
		endWhile
		let row=row+1
	endWhile
elif readingMethod==tableColByCol then
; read column by column
	let col=1
	while col <=table.columns.count
		if getVerbosity()==beginner then
			sayUsingVoice(vctx_message,msg378a+intToString(col),ot_message) ; col
		endIf
		let row=1
		while row <=table.rows.count
			let cell=table.cell(row,col)
			if getVerbosity()==beginner then
				sayUsingVoice(vctx_message,msg376a+intToString(row),ot_message) ; row
			endIf
			if cell.shape.hasTextFrame() then
				if cell.shape.textFrame.hasText() then
					say(cell.shape.textFrame.textRange.text,ot_message)
				else
					say(msg21,ot_message)
				endIf
			else
				say(msg21,ot_message)
			endIf
			let row=row+1
		endWhile
		let col=col+1
	 endWhile
elif readingMethod==tableDimensionsOnly then
	sayUsingVoice(vctx_message,getTableDimensions(table),ot_message)
;else ; readingMethod==tableIgnore
; do nothing.
endIf
EndFunction

Script readTableRowByRow ()
var
object table,
object selectedShape
if oPpt.activeWindow.selection.type !=ppSelectionShapes then
	say(msg379,ot_message) ; no table selected	
	return
endIf
let selectedShape=oPpt.activeWindow.selection.shapeRange(1)
if not selectedShape.hasTable then
	say(msg379,ot_message) ; no table selected	
	return
endIf
let table=selectedShape.table
readTable(table, tableRowByRow)
EndScript

Script readTableColumnByColumn ()
var
object table,
object cell,
object selectedShape,
int row,
int col

if oPpt.activeWindow.selection.type !=ppSelectionShapes then
	say(msg379,ot_message) ; no table selected	
	return
endIf
let selectedShape=oPpt.activeWindow.selection.shapeRange(1)
if not selectedShape.hasTable then
	say(msg379,ot_message) ; no table selected	
	return
endIf
let table=selectedShape.table
readTable(table,tableColByCol)
EndScript

string Function GetShapeDescription (object shape)
if shape.type()==MsoAutoShape then
  return GetAutoshapeDescription(shape)
elif shape.type()==msoEmbeddedOLEObject then
  return GetOleObjDescription(shape)
elif shape.type()==msoPlaceholder then
  return getShapePlaceHolderDescription(shape)
elif shape.type()==msoCallout then
  return msg242 ;"callout", ; 2,
elif shape.type()==msoChart then
  return msg243 ;"chart", ; 3,
elif shape.type()==msoComment then
  return msg244 ;"comment", ; 4,
elif shape.type()==msoFormControl then
  return msg248 ;"form control", ; 8,
elif shape.type()==msoFreeform then
  return msg245 ;"freeform", ; 5,
elif shape.type()==msoGroup then
  return msg246 ;"group", ; 6,
elif shape.type()==msoLine then
  return msg249 ;"line", ; 9,
elif shape.type()==msoLinkedOLEObject then
  return msg250 ;"linked OLE object", ; 10,
elif shape.type()==msoLinkedPicture then
  return msg251 ;"linked picture", ; 11,
elif shape.type()==msoMedia then
  return msg256 ;"media", ; 16,
elif shape.type()==msoOLEControlObject then
  return msg252 ;"OLE control object", ; 12,
elif shape.type()==msoPicture then
  return msg253 ;"picture", ; 13,
;elif shape.type()==msoShapeTypeMixed then
;  return msg252m ;"shape type mixed", ; -2,
elif shape.type()==msoTextBox then
  return msg257 ;"text box" ; 17,
elif shape.type==msoTable then ; 19
	return msg94 ; table
else
	return shape.name()
endIf
EndFunction

String Function GetHyperlinkAddress (object hyperlink, int index)
var
string address

if hyperlink.address() !="" then
  let address=hyperlink.address()
elif hyperlink.subAddress() !="" then
  let address=hyperlink.subAddress()
elif index!=NoLinkIndex then
  let address=msg50+intToString(index+1)
else
  let address=msg50
endIf
return address
EndFunction

String Function GetShapeSummaryText (object shape)
var
string altText
if shape.actionSettings(ppMouseOver).action()==ppActionHyperlink then
  let altText=altText+getHyperlinkAddress(shape.actionSettings(ppMouseOver).hyperlink(), NoLinkIndex)
elif shape.actionSettings(ppMouseClick).action()==ppActionHyperlink then
  let altText=altText+getHyperlinkAddress(shape.actionSettings(ppMouseClick).hyperlink(), NoLinkIndex)
else
  let altText=shape.name()
endIf
let altText=altText+" "
  let altText=AltText+getShapeDescription(shape)
let altText=subString(altText,1,DlgLstItemMaxLength)
if shape.hasTextFrame() then
  if shape.textFrame.hasText() then
    return substring(shape.textFrame.TextRange.text(),1,DlgLstItemMaxLength)
  else
    return altText
  endIf
else
  return altText
endIf 
EndFunction


string Function getParagraphAlignment (object para)
if para.paragraphFormat.alignment==ppAlignCenter then
	return msg584
elif para.paragraphFormat.alignment==ppAlignDistribute then
	return msg585
elif para.paragraphFormat.alignment==ppAlignJustify then
	return msg586
elif para.paragraphFormat.alignment==ppAlignLeft then
	return msg587
elif para.paragraphFormat.alignment < 0 then ; ppAlignmentMixed then
	return msg588
elif para.paragraphFormat.alignment==ppAlignRight then
	return msg589
endIf
EndFunction
Int Function getShapeAnimatedParagraphCount (object shape)
var
int effect,
int animationStatus,
int hasTextFrame,
int hasText

if !shape then
	return 0
endIf
let effect=shape.animationSettings.textUnitEffect
let animationStatus=shape.animationSettings.animate
let hasTextFrame=shape.hasTextFrame
if hasTextFrame then
let hasText=shape.textFrame.hasText
endIf
if hasText && animationStatus &&	effect==ppAnimateByParagraph then
	return shape.textFrame.textRange.paragraphs.count
else
	return 0
endIf
EndFunction


Int Function getShapeParagraphCount (object shape)
if shape.hasTextFrame then
	if shape.textFrame.hasText then
		return shape.textFrame.textRange.paragraphs.count
	endIf
endIf
return 0
EndFunction

Void Function readParagraphs (object shape, int TextOnly)
var
int paraCount,
int priorLevel,
int priorAlignment,
int index,
object textRange
let paraCount=shape.textFrame.textRange.paragraphs.count
let index=1
while index <=paraCount
	let textRange=shape.textFrame.textRange.paragraphs(index)
	if textRange.characters.count > 1 then ; non blank para
		if (getJCFOption(OPT_FORMAT_AND_TEXT)==true && not textOnly) 
	&& (priorLevel  != textRange.indentLevel) then
			sayUsingVoice(VCTX_MESSAGE,msg581+intToString(textRange.indentLevel),ot_status)
			let priorLevel=textRange.indentLevel
		endIf
		if (getJCFOption(OPT_FORMAT_AND_TEXT)==true && not textOnly) 
	&& (priorAlignment!= textRange.paragraphFormat.alignment) then
			sayUsingVoice(VCTX_MESSAGE,getParagraphAlignment(textRange), ot_status)
			let priorAlignment=textRange.paragraphFormat.alignment
		endIf
		if textRange.paragraphFormat.bullet.visible then
			say(msg582,ot_string)
		endIf
		say(textRange.text,ot_text)
	endIf
	let index=index+1
endWhile
EndFunction

Void Function SayShape (object shape, int textOnly)
if not shape.visible() then
  return
endIf
if GetVerbosity() < advanced && (not TextOnly || shape.hasTable) then
    sayUsingVoice(VCTX_MESSAGE, GetShapeDescription(shape), ot_string)
  if shape.actionSettings(ppMouseOver).action()==ppActionHyperlink then
    SayUsingVoice(VCTX_MESSAGE, msg50, ot_string) ; link
        SayUsingVoice(VCTX_MESSAGE, getHyperlinkAddress(shape.actionSettings(ppMouseOver).hyperlink(), NoLinkIndex), ot_string)
    if getVerbosity()==beginner then
          SayUsingVoice(VCTX_MESSAGE,msg51, ot_string) ; on mouse over
    endIf
  elif shape.actionSettings(ppMouseClick).action()==ppActionHyperlink then
        SayUsingVoice(VCTX_MESSAGE,msg50, ot_string) ; link
        SayUsingVoice(VCTX_MESSAGE,getHyperlinkAddress(shape.actionSettings(ppMouseClick).hyperlink(), NoLinkIndex), ot_string)
    if getVerbosity()==beginner then
          SayUsingVoice(VCTX_MESSAGE,msg52, ot_string) ; on mouse click
    endIf
  endIf
endIf
if shape.HasTextFrame() then
	if shape.textFrame.hasText() then
		readParagraphs(shape, textOnly)
	endIf
elif shape.alternativeText !="" then
; PP 2000 only
	sayUsingVoice(vctx_message,shape.alternativeText,ot_text)
elif shape.hasTable then
	readTable(shape.table, globalTableReadingMethod)
endIf
EndFunction

Script toggleTableReadingMethod ()
if globalTableReadingMethod==tableIgnore then
	say(msg367,ot_message) ; read row by row
	let globalTableReadingMethod=tableRowByRow
elif globalTableReadingMethod==tableRowByRow then
	say(msg368,ot_message) ; read column by column
	let globalTableReadingMethod=tableColByCol
elif globalTableReadingMethod==tableColByCol then
	say(msg366,ot_message) ; say table dimensions.
	let globalTableReadingMethod=tableDimensionsOnly
else 
	say(msg369,ot_message) ; ignore tables altogether 
	let globalTableReadingMethod=tableIgnore
endIf
EndScript

void Function SaySelectedShape ()
var
object selection,
int type

let selection =oPpt.activeWindow.selection()
pause()
if !selection then
  return
endIf
let type =selection.type()
if type==ppSelectionShapes then
  sayShape(selection.shapeRange(1),false)
endIf
EndFunction

object Function GetSlideWithFocus ()
var
object slide,
int ViewType

; next 4 lines should not be necessary but app obj is not always obtained properly during autostart.
if !oPpt then
	say(msg387,ot_help) ; didn't get app obj etc	return
	say(msg388,ot_help) ; rest of above msg
endIf

let viewType=oPpt.activeWindow.viewType()
if viewType==0 then
; try get slide from slide show window of active presentation
  let slide=oPpt.activePresentation.slideShowWindow.view.slide
else
	let slide=oPpt.ActiveWindow.view.slide()
endIf
pause()
if slide then
	return slide
else
	return null
endIf
EndFunction

String Function GetSlideHeader (object slide)
if slide.HeadersFooters.header.visible() then
  return slide.headersFooters.header.text()
else
  return slide.name()
endIf
EndFunction

String Function GetSlideTitleOrIndexNumber (object slide)
var
object shape,
string tempStr

let shape=slide.shapes.placeholders(1)
let TempStr=shape.textFrame.textRange.text()
if tempStr=="" then
  let TempStr=intToString(slide.slideIndex())
  let tempStr=msg413a+tempStr ; slide index
endIf 
return tempStr
EndFunction

string Function GetSlideFooter (object slide)
if slide.HeadersFooters.footer.visible() then
return slide.headersFooters.footer.text()
else
  return ""
endIf
EndFunction

String Function GetSlideDateAndTime (object slide)
if slide.HeadersFooters.dateAndTime.visible() then
  return slide.headersFooters.DateAndTime.text()
else
  return ""
endIf
EndFunction

String Function GetSlideEntryEffect (object slide)
var
int entryEffect
let entryEffect=slide.slideShowTransition.entryEffect()

if EntryEffect==ppEffectAppear then 
	return msg501
elif EntryEffect==ppEffectBlindsHorizontal then 
	return msg502
elif EntryEffect==ppEffectBlindsVertical then 
	return msg503
elif EntryEffect==ppEffectBoxIn then 
	return msg504
elif EntryEffect==ppEffectBoxOut then 
	return msg505
elif EntryEffect==ppEffectCheckerboardAcross then 
	return msg506
elif EntryEffect==ppEffectCheckerboardDown then 
	return msg507
elif EntryEffect==ppEffectCoverDown then 
	return msg508
elif EntryEffect==ppEffectCoverLeft then 
	return msg509
elif EntryEffect==ppEffectCoverLeftDown then 
	return msg510
elif EntryEffect==ppEffectCoverLeftUp then 
	return msg511
elif EntryEffect==ppEffectCoverRight then 
	return msg512
elif EntryEffect==ppEffectCoverRightDown then 
	return msg513
elif EntryEffect==ppEffectCoverRightUp then 
	return msg514
elif EntryEffect==ppEffectCoverUp then 
	return msg515
elif EntryEffect==ppEffectCrawlFromDown then 
	return msg516
elif EntryEffect==ppEffectCrawlFromLeft then 
	return msg517
elif EntryEffect==ppEffectCrawlFromRight then 
	return msg518
elif EntryEffect==ppEffectCrawlFromUp then 
	return msg519
elif EntryEffect==ppEffectCut then 
	return msg520
elif EntryEffect==ppEffectCutThroughBlack then 
	return msg521
elif EntryEffect==ppEffectDissolve then 
	return msg522
elif EntryEffect==ppEffectFade then 
	return msg523
elif EntryEffect==ppEffectFlashOnceFast then 
	return msg524
elif EntryEffect==ppEffectFlashOnceMedium then 
	return msg525
elif EntryEffect==ppEffectFlashOnceSlow then 
	return msg526
elif EntryEffect==ppEffectFlyFromBottom then 
	return msg527
elif EntryEffect==ppEffectFlyFromBottomLeft then 
	return msg528
elif EntryEffect==ppEffectFlyFromBottomRight then 
	return msg529
elif EntryEffect==ppEffectFlyFromLeft then 
	return msg530
elif EntryEffect==ppEffectFlyFromRight then 
	return msg531
elif EntryEffect==ppEffectFlyFromTop then 
	return msg532
elif EntryEffect==ppEffectFlyFromTopLeft then 
	return msg533
elif EntryEffect==ppEffectFlyFromTopRight then 
	return msg534
;elif EntryEffect==ppEffectMixed 
;	then return msg535
elif EntryEffect==ppEffectNone then 
	return msg536
elif EntryEffect==ppEffectPeekFromDown then 
	return msg537
elif EntryEffect==ppEffectPeekFromLeft then 
	return msg538
elif EntryEffect==ppEffectPeekFromRight then 
	return msg539
elif EntryEffect==ppEffectPeekFromUp then 
	return msg540
elif EntryEffect==ppEffectRandom then 
	return msg541
elif EntryEffect==ppEffectRandomBarsHorizontal then 
	return msg542
elif EntryEffect==ppEffectRandomBarsVertical then 
	return msg543
elif EntryEffect==ppEffectSpiral then 
	return msg544
elif EntryEffect==ppEffectSplitHorizontalIn then 
	return msg545
elif EntryEffect==ppEffectSplitHorizontalOut then 
	return msg546
elif EntryEffect==ppEffectSplitVerticalIn then 
	return msg547
elif EntryEffect==ppEffectSplitVerticalOut then 
	return msg548
elif EntryEffect==ppEffectStretchAcross then 
	return msg549
elif EntryEffect==ppEffectStretchDown then 
	return msg550
elif EntryEffect==ppEffectStretchLeft then 
	return msg551
elif EntryEffect==ppEffectStretchRight then 
	return msg552
elif EntryEffect==ppEffectStretchUp then 
	return msg553
elif EntryEffect==ppEffectStripsDownLeft then 
	return msg554
elif EntryEffect==ppEffectStripsDownRight then 
	return msg555
elif EntryEffect==ppEffectStripsLeftDown then 
	return msg556
elif EntryEffect==ppEffectStripsLeftUp then 
	return msg557
elif EntryEffect==ppEffectStripsRightDown then 
	return msg558
elif EntryEffect==ppEffectStripsRightUp then 
	return msg559
elif EntryEffect==ppEffectStripsUpLeft then 
	return msg560
elif EntryEffect==ppEffectStripsUpRight then 
	return msg561
elif EntryEffect==ppEffectSwivel then 
	return msg562
elif EntryEffect==ppEffectUncoverDown then 
	return msg563
elif EntryEffect==ppEffectUncoverLeft then 
	return msg564
elif EntryEffect==ppEffectUncoverLeftDown then 
	return msg565
elif EntryEffect==ppEffectUncoverLeftUp then 
	return msg566
elif EntryEffect==ppEffectUncoverRight then 
	return msg567
elif EntryEffect==ppEffectUncoverRightDown then 
	return msg568
elif EntryEffect==ppEffectUncoverRightUp then 
	return msg569
elif EntryEffect==ppEffectUncoverUp then 
	return msg570
elif EntryEffect==ppEffectWipeDown then 
	return msg571
elif EntryEffect==ppEffectWipeLeft then 
	return msg572
elif EntryEffect==ppEffectWipeRight then 
	return msg573
elif EntryEffect==ppEffectWipeUp then 
	return msg574
elif EntryEffect==ppEffectZoomBottom then 
	return msg575
elif EntryEffect==ppEffectZoomCenter then 
	return msg576
elif EntryEffect==ppEffectZoomIn then 
	return msg577
elif EntryEffect==ppEffectZoomInSlightly then 
	return msg578
elif EntryEffect==ppEffectZoomOut then 
	return msg579
elif EntryEffect==ppEffectZoomOutSlightly then 
	return msg580
endIf
EndFunction

Function SayCurrentSlideTransition ()
var
object slide

let slide=GetSlideWithFocus()
  if GetVerbosity()==beginner then
    say(msg500, ot_help) ; entry effect is
  endIf
say(GetSlideEntryEffect(slide), ot_status)
if slide.SlideShowTransition.advanceOnClick() then
  say(msg428, ot_status) ; advances on mouse click
elif slide.SlideShowTransition.advanceOnTime() then
  say(msg429, ot_status) ; advance on time.
	say(msg430+inttoString(slide.slideShowTransition.advanceTime)+msg431,ot_message)	
endIf
EndFunction

Function readSlideUpToShapeAndPara (object slide, int lastShapeIndex, int lastParaIndex)
var
object shape,
object textRange,
int shapeIndex,
int paraIndex,
int priorAlignment,
int priorLevel


 let shapeIndex=1
while shapeIndex <=lastShapeIndex
	let shape=slide.shapes(shapeIndex)
	sayUsingVoice(vctx_message,getShapeDescription(shape),ot_message)
	if shape.hasTextFrame then
		if shape.TextFrame.hasText then
			let paraIndex=1
			while paraIndex <=lastParaIndex
				let textRange=shape.textFrame.textRange.paragraphs(paraIndex)
				if textRange.characters.count > 1 then
					if (getJCFOption(OPT_FORMAT_AND_TEXT)==true && priorLevel  != textRange.indentLevel) then
						sayUsingVoice(VCTX_MESSAGE,msg581+intToString(textRange.indentLevel),ot_status)
						let priorLevel=textRange.indentLevel
					endIf
					if (getJCFOption(OPT_FORMAT_AND_TEXT)==true && priorAlignment!= textRange.paragraphFormat.alignment) then
						sayUsingVoice(VCTX_MESSAGE,getParagraphAlignment(textRange), ot_status)
						let priorAlignment=textRange.paragraphFormat.alignment
					endIf
					if textRange.paragraphFormat.bullet.visible then
						say(msg582,ot_string)
					endIf
					say(textRange.text,ot_text)
				endIf
				let paraIndex=paraIndex+1
			endWhile
		endIf
	endIf
	let shapeIndex=shapeIndex+1
endWhile


EndFunction

Void Function ReadSlide (object slide, int TextOnly, int upToShapeIndex, int upToParaIndex)
var
object shape,
int ShapeCount,
int Index
let Index=1
if upToShapeIndex > 0 then
	let shapeCount=upToShapeIndex
else
	let shapeCount=slide.shapes.count()
endIf
while Index <=ShapeCount
	let shape=slide.shapes(Index)
	sayShape(slide.shapes(Index), textOnly)
	pause()
	let Index=Index+1
EndWhile
EndFunction

Script ReadCurrentSlide ()
var
object slide
let slide=getSlideWithFocus()
if !slide then
  say(msg100,ot_help) ; cannot use this function in this view.
  return
endIf
ReadSlide(slide,false,0,0)
EndScript

Script SaySelectedObject ()
var
object selection,
int type
if getWindowClass(getFocus())!=wc6 then
		performScript saySelectedText() ; default
	return
endIf
let selection =oPpt.activeWindow.selection()
if !selection && getCharacterAttributes()==attrib_highlight then
		performScript saySelectedText() ; default
	return
endIf
let type =selection.type()
if type==ppSelectionSlides then
	saySlide(selection.slideRange(1))
 elif type==ppSelectionShapes then
	if selection.shapeRange.count > 0 then
		sayShape(selection.shapeRange(1),false)
	else
		sayUsingVoice(VCTX_MESSAGE,msg17a,ot_status) ; no selection
	endIf
elif type==ppSelectionText then
	if selection.textRange.characters.count > 0 then
		say(msg17,ot_help) ; "selected text is"
		say(selection.textrange.text(),ot_text)
	endIf
else
	sayUsingVoice(VCTX_MESSAGE,msg17a,ot_status) ; no selection
endIf
EndScript
string Function GetSlideLayout (object slide)
var
int layout
let layout=slide.layout()
if layout==Blank then
  return msg21 ; "blank"
elif layout==Chart then
  return msg22 ; "chart"
elif layout==ChartAndTxt then
  return msg23 ; "chart and text"
elif layout==ClipartAndTxt then
  return msg24 ; "clipart and text"
elif layout==ClipArtAndVerticalTxt then
  return msg25 ; "clipart and vertical text"
elif layout==FourObjs then
  return msg26 ; "four objects"
elif layout==LargeObj then
  return msg27 ; "large object"
elif layout==MediaClipAndTxt then
  return msg28 ; "media clip and text"
;elif layout==Mixed then ; negative constant 
;  return msg29 ; "mixed"
elif layout==Obj then
  return msg30 ; "object"
elif layout==ObjAndTxt then
  return msg31 ; "object and text"
elif layout==ObjOverTxt then
  return msg32 ; "object over text"
elif layout==Orgchart then
  return msg33 ; "Org Chart"
elif layout==TableSlide then
  return msg34 ; "table"
elif layout==Txt then
  return msg35 ; "text"
elif layout==TxtAndChart then
  return msg36 ; "text and chart"
elif layout==TxtAndClipart then
  return msg37 ; "text and clipart"
elif layout==TxtAndMediaClip then
  return msg38 ; "text and media clip"
elif layout==TxtAndObj then
  return msg39 ; "text and object"
elif layout==TxtAndTwoObjs then
  return msg40 ; "text and two objects"
elif layout==TxtOverObj then
  return msg41 ; "text over object"
elif layout==Title then
  return msg42 ; "title" 
elif layout==TitleOnly then
  return msg43 ; "title only"
elif layout==TwoColumnTxt then
  return msg44 ; "two column text"
elif layout==TwoObjsAndTxt then
  return msg45 ; "two objects and text"
elif layout==TwoObjsOverTxt then
  return msg46 ; "two objects over text"
elif layout==VerticalTxt then
  return msg47 ; "vertical text"
elif layout==VerticalTitleAndTxt then
  return msg48 ; "vertical title and text"
elif layout==VerticalTitleAndTxtOverChart then
  return msg49 ; "vertical title and text over chart"
else
	sayInteger(layout)
endIf
EndFunction

Void Function SayCurrentSlideLayout ()
var
object slide
let slide=getSlideWithFocus()
if !slide then
  say(msg100,ot_help) ; cannot use this function in this view.
  return
endIf
if slide.layout !=0 then
	say(msg20,ot_help) ; slide layout type is
	say(GetSlideLayout(slide),ot_status)
endIf
EndFunction

Script selectShape ()
var
object shape,
int shapeIndex,
string ShapeList,
int shapeCount,
int ShapeToSelect,
object slide
if isSlideShow() then
	say(msg100,ot_message) ; cannot use this function in this view.
	return
endIf
let slide=getSlideWithFocus()
if !slide then
  say(msg100,ot_help) ; cannot use this function in this view.
  return
endIf
let shapeCount=slide.shapes.count()
if shapeCount < 1 then
  sayUsingVoice(VCTX_MESSAGE,msg53,ot_help) ; no shapes
  return
endIf
let shapeIndex=1
while shapeIndex <= ShapeCount
  let shape=slide.shapes(shapeIndex)
  let shapeList=ShapeList+GetShapeSummaryText(shape)+msg16
  let ShapeIndex=ShapeIndex+1
EndWhile
; ensure no fantom empty item at end of list
let shapeList=stringLeft(shapeList,stringLength(shapeList)-1)
let shapeToSelect=DlgSelectItemInList (ShapeList, msg54, false)
if shapeToSelect > 0 then
  slide.shapes(shapeToSelect).select()
  say(GetShapeSummaryText(slide.shapes(shapeToSelect)),ot_text)
  sayUsingVoice(VCTX_MESSAGE,msg55,ot_status) ; shape selected
endIf
EndScript


Script SelectHyperlink ()
var
object hyperlink,
string address,
string SubAddress,
int Index,
string LinkList,
int Count,
int LinkSelected,
object slide
if isSlideShow() then
	say(msg100,ot_message) ; cannot use this function in this view.
	return
endIf

let slide=getSlideWithFocus()
if !slide then
  say(msg100, ot_help) ; cannot use this function in this view.
  return
endIf
let Count=slide.hyperlinks.count()
if Count < 1 then
  sayUsingVoice(VCTX_MESSAGE,msg56,ot_help) ; no hyperlinks on slide 
  return
endIf
let Index=1
while Index <= Count
  let hyperlink=slide.hyperlinks(Index)
  let address=GetHyperlinkAddress(hyperlink, index)
  let LinkList=LinkList+address+msg16
  let Index=Index+1
EndWhile
; ensure no fantom empty item at end of list
let linkList=stringLeft(linkList,stringLength(linkList)-1)
let LinkSelected=DlgSelectItemInList (LinkList, msg57, false)
if linkSelected > 0 then
  let address=slide.hyperlinks(linkSelected).address()
  let subAddress=slide.hyperlinks(linkSelected).SubAddress()
  if GetVerbosity()==beginner then
    sayUsingVoice(VCTX_MESSAGE,msg58,ot_status) ; hyperlink selected
  endIf
  oPpt.activePresentation.followHyperlink(address,subAddress)
endIf
EndScript


Script FollowSelectedHyperlink ()
var
string address,
string subAddress,
object shape
if OPpt.activeWindow.selection.type()==ppSelectionShapes then
  let shape=OPpt.activeWindow.selection.shapeRange(1)
  if shape.actionSettings(ppMouseOver).action()==ppActionHyperlink then
    if GetVerbosity()==beginner then
      sayUsingVoice(VCTX_MESSAGE,msg58,ot_status) ; link selected  
    endIf
    let address=shape.actionSettings(ppMouseOver).hyperlink.address()
    let SubAddress=shape.actionSettings(ppMouseOver).hyperlink.SubAddress()
    oPpt.activePresentation.followHyperlink(address,subAddress)
    pause()
    say(GetSlideTitleOrIndexNumber (GetSlideWithFocus()),ot_text)
  elif shape.actionSettings(ppMouseClick).action()==ppActionHyperlink then
    if GetVerbosity()==beginner then
      sayUsingVoice(VCTX_MESSAGE,msg58,ot_status) ; link selected  
    endIf
    let address=shape.actionSettings(ppMouseClick).hyperlink.address()
    let SubAddress=shape.actionSettings(ppMouseClick).hyperlink.SubAddress()
    oPpt.activePresentation.followHyperlink(address,subAddress)
    pause()
    say(GetSlideTitleOrIndexNumber (GetSlideWithFocus()),ot_text)
  else
    sayUsingVoice(VCTX_MESSAGE,msg59,ot_help) ; this shape is not a hyperlink 
  endIf
else
  sayUsingVoice(VCTX_MESSAGE,msg59,ot_help) ; this shape is not a hyperlink 
EndIf
EndScript

Script NextObject ()
var
int Typing_echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
If (Typing_Echo != 0) Then
	Say (msgTab,ot_message)
endIf

let PptFocusChangeCalled=false
let PptSuppressEcho=true
{tab}
; need next three lines to avoid speaking selected shape while in SDM dialogs
if DialogActive() then
  return
endIf
pause()
if PptFocusChangeCalled==false then
  SaySelectedShape()
endIf
EndScript

Script PriorObject ()
var
int Typing_echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
If (Typing_Echo != 0) Then
	Say (msgShiftTab,ot_message)
endIf

let PptFocusChangeCalled=false
let PptSuppressEcho=true
{shift+tab}
; need next three lines to avoid speaking selected shape while in SDM dialogs
if DialogActive() then
  return
endIf
pause()
if PptFocusChangeCalled==false then
  SaySelectedShape()
endIf
EndScript

Script PriorSlide ()
var
object slide
JAWSPageUp()
if IsPCCursor() then
  If (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
   GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
delay(2)
     SayWord()
     return
  endif
; only want to do this if viewing a slide
if GetWindowClass(GetFocus())==wc6 then
	pause()
	let slide=getSlideWithFocus()
	if slide.slideIndex > 0 then
		say(GetSlideTitleOrIndexNumber(slide), ot_help)
	endIf
else
  sayLine()
endIf
return
endif
EndScript

Script NextSlide ()
var
object slide

JAWSPageDown()
if IsPCCursor() then
  if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
   GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
delay(2)
     SayWord()
     return
  endif
; only want to do this if viewing a slide
if GetWindowClass(GetFocus())==wc6 then
	pause()
	let slide=getSlideWithFocus()
	if slide then
		say(GetSlideTitleOrIndexNumber(slide), ot_help)
	endIf
else
  sayLine()
endIf
return
endif
EndScript

Script SayFont ()
var
	string strBuffer,
	object controls
if not (IsPCCursor ()) then
	PerformScript SayFont ()
	return ; all done, jaws or invisible cursor is on
EndIf ;is not pc cursor
if (GetWindowClass (GetCurrentWindow ()) != wc6) then
	PerformScript SayFont ()
	return
EndIf
let controls = oPpt.commandbars(CBFormatting).controls()
if (ButtonIsPressed(controls,"bold")) then
	say (msg318,ot_status) ;"bolded"
EndIf
if (ButtonIsPressed(controls,"italic")) then
	say (msg320,ot_status) ;"italicized"
EndIf
if (ButtonIsPressed(controls,"underline")) then
	say (msg322,ot_status) ;"underlined"
EndIf
if (ButtonIsPressed(controls,"align left")) then
	say (msg324,ot_status) ;"Aligned left"
EndIf
if (ButtonIsPressed(controls,"center")) then
	say (msg326,ot_status) ;"Centered"
EndIf
if (ButtonIsPressed(controls,"align right")) then
	say (msg328,ot_status) ;"aligned right"
EndIf
if (ButtonIsPressed(controls,"justify")) then
	say (msg330,ot_status) ;"justified"
EndIf
let strBuffer = oPpt.commandbars(CBFormatting).controls(1).text()
if (strBuffer != "") then
	say (strBuffer,ot_text)
else
	say (msg341,ot_status) ; "Mixed Font")
EndIf
let strBuffer = oPpt.commandbars(CBFormatting).controls(2).text()
if (strBuffer != "") then
	say (strBuffer,ot_text)
	say(msg342,ot_help) ; point
else
	say (msg343,ot_status) ;"Mixed point size")
EndIf
if (GetCharacterAttributes () & attrib_highlight) then
	say (msg317,ot_status) ; "Highlighted")
EndIf
EndScript

int function ButtonIsPressed (object controls, string strButtonName)
var
	int nResult
let nResult = controls(strButtonName).state()
if (nResult < 0) then
	return TRUE
else
	return FALSE
endif
EndFunction

Void Function ReportFont (string strButton, string strButtonPressed)
var
	int state
pause()
let state = oPpt.commandbars(CBFormatting).controls(strButton).state()
if (state == -1) then
	say (strButtonPressed,ot_status)
else
	say (strButton,ot_status)
endif
EndFunction

Script BoldText ()
{control+b}
ReportFont (btnBold, msg344)
EndScript

Script ItalicText ()
{control+i}
ReportFont (btnItalic, msg345)
EndScript

Script UnderlineText ()
{control+u}
ReportFont (btnUnderline, msg346)
EndScript

Script CenterText ()
{control+e}
pause()
say (msg347,ot_status) ;"centered"
EndScript

 Script  LeftJustify()
{control + l}
Pause ()
say (msg348,ot_status) ;"Left aligned"
EndScript

Script rightJustify ()
{control + r}
Pause ()
say (msg349,ot_status) ;"right aligned"
EndScript

Script ScreenSensitiveHelp ()
var
handle realWindow,
handle focus,
string focusClass,
string realName,
string realClass,
int FocusId,
object slide,
int shapeCount,
int hyperlinkCount

let focus=getFocus()
let focusClass=getWindowClass(focus)
let FocusId=GetControlId(focus)
let realWindow=getRealWindow(focus)
let realClass=getWindowClass(realWindow)
let realName=getWindowName(realWindow)
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf

if focusClass==wc2 && realName==NewSlideDlgTitle then
	say(msg18,ot_help) ; "This is the new slide dialog. choose an autolayout using the up and down arrow keys and press Enter to continue."  
	say(msg19,ot_help) ; rest of above msg
elif realName==SpellingDlgTitle then
	say(msg422,ot_help) ; this is the Spell Checker dialog.
	say(msg423+msg300+GetScriptKeyName("spellCheck")+msg306,ot_help)
	say(msg424,ot_help) ; use tab and shift+tab to move betwen the options.
elif realName==BulletDlgTitle then
	say(msg19a,ot_help) ; this is the bullet dialog. 
	if FocusId==BulletTypeId then
		say(msg351a,ot_help) ; choose a bullet type using the up and down arrows.
	elif focusClass==wc2 then
		say(msg414,ot_help) ; popup menu auto activated etc
	elif GetWindowSubtypeCode(focus)==wt_3state then
		say(msg415,ot_help) ; this is a threestate button, similar to a checkbox.
		say(msg416,ot_help)
		say(msg417,ot_help)
	else
		PerformScript ScreenSensitiveHelp()
	endIf
elif realName==BackgroundDlgTitle then 
	say(msg19b,ot_help) ; this is the Background dialog.
	if focusClass==wc2 then
		say(msg414,ot_help) ; popup menu auto activated etc
	elif GetWindowSubtypeCode(focus)==wt_3state then
		say(msg415,ot_help) ; this is a threestate button, similar to a checkbox.
		say(msg416,ot_help)
		say(msg417,ot_help)
	else
		PerformScript ScreenSensitiveHelp()
	endIf
elif realName==ColorSchemeDlgTitle then
	say(msg420,ot_help) ; This is the color scheme multiPage dialog.
	if focusClass==wc2 then
		say(msg418,ot_help)
		say(msg419,ot_help)
	else
		PerformScript ScreenSensitiveHelp()
	EndIf
elif realName==setUpShowDlgTitle then
	say(msg332,ot_help) ; This is the set up show dlg
	if focusClass==wc2 then
		say(msg331,ot_help) ; this is the pen selection menu
		say(msg414,ot_help)
	else
		PerformScript ScreenSensitiveHelp()
	EndIf
elif focusClass==wc6 then
	let slide=GetSlideWithFocus()
	if !slide then
		if not isSlideShow() then
			saySlideShowState()
			say(msg601,ot_message) ; press any key to return to the prior view.
			return
		endIf
	endIf
	if getVerbosity()==beginner then
		say(msg305,ot_help) ; you are in
	endIf
	sayPptView()
		if oPpt.activeWindow.viewType==ppViewNormal then ; can switch panels.
			say(msg382,ot_help) ; use f6 to switch panels
		endIf
	if oPpt.activeWindow.activePane.viewType==ppViewNotesPage then
		if getVerbosity()==beginner then
			say(msg305,ot_help) ; this is the
		endIf
		say(msg380+intToString(slide.slideIndex),ot_help) ; notes page for		
		say(msg381,ot_help) ; enter speaker's notes etc.
		return
 elif oPpt.activeWindow.activePane.viewType==ppViewOutline then
		return
	endIf
	sayCurrentSlideLayout()
	let ShapeCount=slide.shapes.count()
	if shapeCount > 0 then
		say(msg409+intToString(shapeCount)+msg410,ot_help) ; the slide contains x shapes.
	endIf
	let hyperlinkCount=slide.hyperlinks.count
	if hyperlinkCount > 0 then
		say(msg409+intToString(hyperlinkCount)+msg56a,ot_help) ; the slide contains x hyperlinks
	endIf 
	if OPpt.activeWindow.selection.type==PPSelectionShapes then
		say(msg594,ot_help) ; you are at the object level
		say(msg301,ot_help) ; tab and shift tab to ... 
		say(msg311+msg312,ot_help) ; Press enter to edit the selected shape's text, press esc etc
		say(msg411,ot_help) ; the selected shape is a 
		say(GetShapeDescription(OPpt.activeWindow.selection.shapeRange(1)),ot_text)
	elif oPpt.activeWindow.selection.type==ppSelectionText then
		say(msg595, ot_help) ; you are currently editing text in the selected shape.
		say(getShapeDescription(oPpt.activeWindow.selection.textrange.parent.parent),ot_help) ; the shape being edited.
		say(msg595a,ot_help) ; press Esc to return to the object level when finished editing text.  	
	elif oPpt.activeWindow.viewType !=0 then ; no shape selected
		say(msg594,ot_help) ; you are at the object level
		say(msg412,ot_help)  ; no shape selected, press tab to select the first object on the slide.
		say(msg311+msg312,ot_help) ; Press enter to edit the selected shape's text, press esc etc
	endIf
elif focusClass==wc7 then
	say(msg359,ot_help) ; you are in an embedded
	say(msg360,ot_help) ; excel 97 worksheet
	say(msg360b,ot_help) ; use the arrows and say character to move around the worksheet and hear cell data and coordinates 
elif focusClass==wc8 then
	say(msg359,ot_help) ; you are in an embedded
	say(msg364,ot_help) ; ms word 97 doc
	say(msg364a,ot_help) ; you can move around as if you were in ms word 97
elif focusClass==wc9 then
	say(msg414,ot_help) ; popup menu auto activated etc
elif GetWindowSubtypeCode(focus)==wt_3state then
	say(msg415,ot_help) ; this is a threestate button, similar to a checkbox.
	say(msg416,ot_help)
	say(msg417,ot_help)
else
	performScript screenSensitiveHelp() ; default
endIf
EndScript
Script PptHotkeyHelp ()
var
handle realWindow,
handle focus,
int CId,
string realName,
string focusClass,
string realClass,
object slide

let slide=getSlideWithFocus() ; if we got a valid slide then we can say the hotkeys appropriate for when a slide has focus.
let focus=getFocus()
let CId=GetControlId(focus)
let focusClass=getWindowClass(focus)
let realWindow=getRealWindow(focus)
let realName=getWindowName(realWindow)
let realClass=getWindowClass(realWindow)
if focusClass==wc2 && realName==NewSlideDlgTitle then
	say(msg19,ot_help) ; "Choose an autolayout using the up and down arrow keys and press Enter to continue."  
elif focusClass==wc6 && slide.name !="" then ; there is a valid slide in focus and we are in the slide window
	say(msg307+msg300+GetScriptKeyName("sayAll")+msg306,ot_help) ; say all calls read current slide.
	say(msg302+msg300+GetScriptKeyName("selectShape")+msg306,ot_help)
	say(msg310+msg300+getScriptKeyName("sayWindowPromptAndText")+msg306,ot_help)
	say(msg400+msg300+getScriptKeyName("sayObjectDimentionsAndLocation")+msg306,ot_help) ; to hear shape dimentions and location 
	say(msg395+msg300+getScriptKeyName("sayShapeAnimationInfo")+msg306,ot_help) ; to hear the selected shape's animation text unit. 
	say(msg399+msg300+getScriptKeyName("toggleFormatAnnouncement")+msg306,ot_help) ; to toggle text format announcement 
	say(msg303a+msg300+getScriptKeyName("FollowSelectedHyperlink")+msg306, ot_help)
	say(msg303+msg300+GetScriptKeyName("selectHyperlink")+msg306, ot_help) 
	say(msg308+msg300+getScriptKeyName("saySelectedObject")+msg306,ot_help) 
	say(msg385+msg300+getScriptKeyName("readTableRowByRow")+msg377+getScriptKeyName("readTableColumnByColumn")+msg306,ot_help) ; to read table row by row or column by column 
	say(msg386+msg300+getScriptKeyName("toggleTableReadingMethod")+msg306,ot_help) ; to toggle the table reading method
		say(msg304a+msg300+getScriptKeyName("saySlideInfo")+msg306,ot_help) ; to speak information about the current slide view or show
endIf
say(msg304+msg300+GetScriptKeyName("speakStatusLine")+msg306,ot_help)
say(msg354+msg300+GetScriptKeyName("closeOfficeAssistant")+msg306,ot_help)
say(msg352+msg300+getScriptKeyName("SayPowerpointVersion")+msg306,ot_help)
EndScript

string Function GetStatusLineText ()
var
handle StatusLineHandle,
handle tmp,
int safety,
string StatusLineText

let safety=10 ; shouldn't be more than 10 windows to search through
let tmp=getAppMainWindow(GetFocus())
let tmp=getFirstChild(tmp)
while tmp || safety
	if getWindowClass(tmp)==wc11 then
		let statusLineHandle=tmp
		let safety=0
	else
		let safety=safety-1
	endIf
	let tmp=getNextWindow(tmp)
endWhile
; wc11="MSCtls_Statusbar32"
if statusLineHandle then
	return GetWindowText(statusLineHandle, read_everything)
else
	return ""
endIf
EndFunction

Script speakStatusLine ()
say(getStatusLineText(),ot_status)
EndScript

Script SaySlideInfo ()
var
object slide,
int ViewType
if DialogActive() || MenusActive() then
  return
endIf
let slide=getSlideWithFocus()
if !slide then
	if isSlideShowDone() then
		saySlideShowState()
	else
		say(msg100,ot_message)
	endIf
	return
endIf
let viewType=oPpt.activeWindow.viewType()
say(GetSlideTitleOrIndexNumber (slide),ot_text)
if ViewType > 0 then
	sayCurrentSlideLayout()
else
	saySlideShowState()
	if oPpt.activePresentation.slideShowWindow.isFullScreen then
		say(msg383,ot_message) ; full screen mode
	else
		say(msg384,ot_message) ; not in full screen mode.
	endIf
	saySlideShowPointerType()
	sayCurrentSlideTransition()
	say(msg375+intToString(getShowElapsedTime()),ot_message)
endIf
EndScript

string Function GetBrlShapeRepresentation (object shape)
var
string BrlStr,
string ShapeText

let brlStr=GetShapeDescription(shape)
if shape.actionSettings(ppMouseOver).action()==ppActionHyperlink then
  let BrlStr=brlStr+" "+msg50 ; link
  let BrlStr=BrlStr+getHyperlinkAddress(shape.actionSettings(ppMouseOver).hyperlink(), NoLinkIndex)
elif shape.actionSettings(ppMouseClick).action()==ppActionHyperlink then
  let brlStr=brlStr+" "+msg50 ; link
  let brlStr=brlStr+getHyperlinkAddress(shape.actionSettings(ppMouseClick).hyperlink(), NoLinkIndex)
endIf
if shape.HasTextFrame() then
  if shape.textframe.hasText() then
    let brlStr=BrlStr+": "
    let ShapeText=shape.textFrame.TextRange.text()
    let brlStr=BrlStr+" "+ShapeText
  endIf
endIf
return BrlStr
EndFunction

int Function BrailleBuildPPFocus ()
if OPpt.activeWindow.selection.type()==ppSelectionShapes then
  BrailleAddString(GetBrlShapeRepresentation(OPpt.activeWindow.selection.shapeRange(1)),0,0,0)
  return true 
elif GetWindowClass(GetFocus())==wc7 then
; excel worksheet
  BrailleAddString(GetExcel97WorksheetCell (OPpt.activeWindow.selection.shapeRange(1).OleFormat.application()),0,0,0)
elif CaretVisible() then
; let normal handling apply,
; probably in an edit field or MS word doc, etc.
  return false
else
  brailleAddString(msg413,0,0,0) ; slide:
  BrailleAddString(GetSlideTitleOrIndexNumber (GetSlideWithFocus()),0,0,0)
  BrailleAddString(GetSlideLayout(GetSlideWithFocus()),0,0,0)
  return true
endIf
  return false
EndFunction

Void Function BrailleBuildLine ()
var
 handle hwndReal,
 string buffer,
 string CheckedUnchecked,
int PixelsPerSpace
let PixelsPerSpace=GetJcfOption (	OPT_PIXELS_PER_SPACE)
SetJcfOption (	OPT_PIXELS_PER_SPACE, 99)
if MenusActive ()
then
BrailleBuildMenu()
Return TRUE
elif
DialogActive ()
Then 
BrailleBuildDialog()
return TRUE
elif 
(GetWindowTypeCode (GetFocus())==WT_LISTVIEW ||
GetWindowTypeCode (GetFocus())==WT_LISTBOX ||
GetWindowTypeCode (GetFocus())==WT_TREEVIEW ||
GetWindowTypeCode (GetFocus())==WT_STARTBUTTON ||
GetWindowTypeCode (GetFocus())==WT_DESKTOP ||
GetWindowTypeCode (GetFocus())==WT_TASKBAR)
then BrailleBuildOther()
 Return TRUE
elif GetWindowClass(GetFocus())==wc6 || GetWindowClass(GetFocus())==wc7  
then BrailleBuildPPFocus()
  return true
else 
return FALSE
endif
SetJcfOption (	OPT_PIXELS_PER_SPACE, PixelsPerSpace)
EndFunction

Function AutoFinishEvent ()
let oPpt = null
EndFunction

Script CloseOfficeAssistant ()
var
handle hWnd,
object OfficeAssistant,
object menubar
; Access 2000
let menubar=msoGetMenubarObject()
let officeAssistant=oPpt.assistant
;note if we could set object properties then it would be a simple matter to set the visible property of the assistant object 
;to false to hide the assistant.
if !officeAssistant.visible then
	say(msg471,ot_string)
	return
endIf
speechOff()
if Menubar.controls(mnuHelp).controls(mnuHelpHideAssistant) then
	{alt+h} ; help
	pause()
	{o} ; toggle Office Assistant to off.
	pause()
else
; no menu item to turn off the assistant, we'll try find it manually.
; This is only applicable to Access 97.
	SaveCursor()
	JAWSCursor()
	let hWnd = FindTopLevelWindow ("MSOAssistant", "")
	if (hWnd && IsWindowVisible (hWnd)) then
		MoveToWindow(hWnd)
		RightMouseButton ()
		pause()
		{h}
		pause()
		RestoreCursor()
	endIf
	delay(10)
endIf
speechOn()
; Test to see if we closed it.
if officeAssistant.visible then
	say(msg474,ot_status)
else
	say(msg473,ot_status)
endIf
endScript

int Function getFirstAnimatedShapeIndex (object slide)
var
object shapeAnimationSettings,
int index,
int count
let index=1
let count=slide.shapes.count
while index <=count
	let shapeAnimationSettings=slide.shapes(index).animationSettings
	if shapeAnimationSettings.animate &&
		shapeAnimationSettings.textLevelEffect!=ppAnimateLevelNone &&
		shapeAnimationSettings.animationOrder==1 then
		return index
	endIf
	let index=index+1
endWhile
return 0
EndFunction

int Function getLastAnimatedShapeIndex (object slide)
var
object shapeAnimationSettings,
int index,
int tmpIndex,
int count

let index=1
let tmpIndex=0
let count=slide.shapes.count
let tmpIndex=getFirstAnimatedShapeIndex(slide)
if tmpIndex ==0 then
	return 0
endIf
while index <=count
	let shapeAnimationSettings=slide.shapes(index).animationSettings
	if shapeAnimationSettings.animate &&
		shapeAnimationSettings.textLevelEffect!=ppAnimateLevelNone then
		if slide.shapes(tmpIndex).animationSettings.animationOrder <=shapeAnimationSettings.animationOrder then
		let tmpIndex=index
		endIf
	endIf
	let index=index+1
endWhile
return tmpIndex
EndFunction

int Function getAnimatedShapeCount (object slide)
var
int index,
int count,
int animatedShapes,
object shapeAnimationSettings

let index=1
let count=slide.shapes.count
let animatedShapes=0
while index <=count
	let shapeAnimationSettings=slide.shapes(index).animationSettings
	if shapeAnimationSettings.animate &&
		shapeAnimationSettings.textLevelEffect!=ppAnimateLevelNone then
		let animatedShapes=animatedShapes+1
	endIf
	let index=index+1
endWhile
return animatedShapes
EndFunction


Int Function getNextAnimatedShapeIndex (object startingShape)
var
object slide,
int endIndex,
int index,
int startIndex,
int tmpIndex, ; will hold the index of the next animated shape at the end
string name,
object shape,
int order

let slide=startingShape.parent
let startIndex=1
let index=startIndex
let endIndex =slide.shapes.count
let order=startingShape.animationSettings.animationOrder
let tmpIndex=0

while index <=endIndex
		let shape=slide.shapes(index)
	if shape.AnimationSettings.animate &&
		shape.AnimationSettings.textLevelEffect!=ppAnimateLevelNone &&
		shape.name !=startingShape.name then
		if shape.animationSettings.animationOrder > order then
			let tmpIndex=index
		endIf
		if tmpIndex > 0 then
			if slide.shapes(tmpIndex).animationSettings.animationOrder >= order &&
				shape.animationSettings.animationOrder <=slide.shapes(tmpIndex).animationSettings.animationOrder then
				let tmpIndex=index
			endIf
		endIf
	endIf
	let index=index+1
endWhile
; tmpIndex should now point to the next shape whose animation order is next highest
return tmpIndex
 EndFunction

Int Function getPriorAnimatedShapeIndex (object startingShape)
var
object slide,
int endIndex,
int index,
int startIndex,
int tmpIndex, ; will hold the index of the prior animated shape at the end
string name,
object shape,
int order

let slide=startingShape.parent
let startIndex=1
let endIndex=slide.shapes.count
let order=startingShape.animationSettings.animationOrder
let index=endIndex

let tmpIndex=0

while index >=startIndex
		let shape=slide.shapes(index)
	if shape.AnimationSettings.animate &&
		shape.AnimationSettings.textLevelEffect!=ppAnimateLevelNone &&
		shape.name !=startingShape.name then
		if shape.animationSettings.animationOrder < order then
			let tmpIndex=index
		endIf
		if tmpIndex > 0 then
			if slide.shapes(tmpIndex).animationSettings.animationOrder <= order &&
				shape.animationSettings.animationOrder >=slide.shapes(tmpIndex).animationSettings.animationOrder then
				let tmpIndex=index
			endIf
		endIf
	endIf
	let index=index-1
endWhile
; tmpIndex should now point to the prior shape whose animation order is next highest
return tmpIndex
 EndFunction

string Function GetShapeEntryEffect (object shape)
var
int entryEffect
let entryEffect=shape.animationSettings.entryEffect()

if EntryEffect==ppEffectAppear then 
	return msg501
elif EntryEffect==ppEffectBlindsHorizontal then 
	return msg502
elif EntryEffect==ppEffectBlindsVertical then 
	return msg503
elif EntryEffect==ppEffectBoxIn then 
	return msg504
elif EntryEffect==ppEffectBoxOut then 
	return msg505
elif EntryEffect==ppEffectCheckerboardAcross then 
	return msg506
elif EntryEffect==ppEffectCheckerboardDown then 
	return msg507
elif EntryEffect==ppEffectCoverDown then 
	return msg508
elif EntryEffect==ppEffectCoverLeft then 
	return msg509
elif EntryEffect==ppEffectCoverLeftDown then 
	return msg510
elif EntryEffect==ppEffectCoverLeftUp then 
	return msg511
elif EntryEffect==ppEffectCoverRight then 
	return msg512
elif EntryEffect==ppEffectCoverRightDown then 
	return msg513
elif EntryEffect==ppEffectCoverRightUp then 
	return msg514
elif EntryEffect==ppEffectCoverUp then 
	return msg515
elif EntryEffect==ppEffectCrawlFromDown then 
	return msg516
elif EntryEffect==ppEffectCrawlFromLeft then 
	return msg517
elif EntryEffect==ppEffectCrawlFromRight then 
	return msg518
elif EntryEffect==ppEffectCrawlFromUp then 
	return msg519
elif EntryEffect==ppEffectCut then 
	return msg520
elif EntryEffect==ppEffectCutThroughBlack then 
	return msg521
elif EntryEffect==ppEffectDissolve then 
	return msg522
elif EntryEffect==ppEffectFade then 
	return msg523
elif EntryEffect==ppEffectFlashOnceFast then 
	return msg524
elif EntryEffect==ppEffectFlashOnceMedium then 
	return msg525
elif EntryEffect==ppEffectFlashOnceSlow then 
	return msg526
elif EntryEffect==ppEffectFlyFromBottom then 
	return msg527
elif EntryEffect==ppEffectFlyFromBottomLeft then 
	return msg528
elif EntryEffect==ppEffectFlyFromBottomRight then 
	return msg529
elif EntryEffect==ppEffectFlyFromLeft then 
	return msg530
elif EntryEffect==ppEffectFlyFromRight then 
	return msg531
elif EntryEffect==ppEffectFlyFromTop then 
	return msg532
elif EntryEffect==ppEffectFlyFromTopLeft then 
	return msg533
elif EntryEffect==ppEffectFlyFromTopRight then 
	return msg534
;elif EntryEffect==ppEffectMixed 
;	then return msg535
elif EntryEffect==ppEffectNone then 
	return msg536
elif EntryEffect==ppEffectPeekFromDown then 
	return msg537
elif EntryEffect==ppEffectPeekFromLeft then 
	return msg538
elif EntryEffect==ppEffectPeekFromRight then 
	return msg539
elif EntryEffect==ppEffectPeekFromUp then 
	return msg540
elif EntryEffect==ppEffectRandom then 
	return msg541
elif EntryEffect==ppEffectRandomBarsHorizontal then 
	return msg542
elif EntryEffect==ppEffectRandomBarsVertical then 
	return msg543
elif EntryEffect==ppEffectSpiral then 
	return msg544
elif EntryEffect==ppEffectSplitHorizontalIn then 
	return msg545
elif EntryEffect==ppEffectSplitHorizontalOut then 
	return msg546
elif EntryEffect==ppEffectSplitVerticalIn then 
	return msg547
elif EntryEffect==ppEffectSplitVerticalOut then 
	return msg548
elif EntryEffect==ppEffectStretchAcross then 
	return msg549
elif EntryEffect==ppEffectStretchDown then 
	return msg550
elif EntryEffect==ppEffectStretchLeft then 
	return msg551
elif EntryEffect==ppEffectStretchRight then 
	return msg552
elif EntryEffect==ppEffectStretchUp then 
	return msg553
elif EntryEffect==ppEffectStripsDownLeft then 
	return msg554
elif EntryEffect==ppEffectStripsDownRight then 
	return msg555
elif EntryEffect==ppEffectStripsLeftDown then 
	return msg556
elif EntryEffect==ppEffectStripsLeftUp then 
	return msg557
elif EntryEffect==ppEffectStripsRightDown then 
	return msg558
elif EntryEffect==ppEffectStripsRightUp then 
	return msg559
elif EntryEffect==ppEffectStripsUpLeft then 
	return msg560
elif EntryEffect==ppEffectStripsUpRight then 
	return msg561
elif EntryEffect==ppEffectSwivel then 
	return msg562
elif EntryEffect==ppEffectUncoverDown then 
	return msg563
elif EntryEffect==ppEffectUncoverLeft then 
	return msg564
elif EntryEffect==ppEffectUncoverLeftDown then 
	return msg565
elif EntryEffect==ppEffectUncoverLeftUp then 
	return msg566
elif EntryEffect==ppEffectUncoverRight then 
	return msg567
elif EntryEffect==ppEffectUncoverRightDown then 
	return msg568
elif EntryEffect==ppEffectUncoverRightUp then 
	return msg569
elif EntryEffect==ppEffectUncoverUp then 
	return msg570
elif EntryEffect==ppEffectWipeDown then 
	return msg571
elif EntryEffect==ppEffectWipeLeft then 
	return msg572
elif EntryEffect==ppEffectWipeRight then 
	return msg573
elif EntryEffect==ppEffectWipeUp then 
	return msg574
elif EntryEffect==ppEffectZoomBottom then 
	return msg575
elif EntryEffect==ppEffectZoomCenter then 
	return msg576
elif EntryEffect==ppEffectZoomIn then 
	return msg577
elif EntryEffect==ppEffectZoomInSlightly then 
	return msg578
elif EntryEffect==ppEffectZoomOut then 
	return msg579
elif EntryEffect==ppEffectZoomOutSlightly then 
	return msg580
endIf
EndFunction

Void Function readAnimatedText (object shape, int TextOnly, int ByRef ParaIndexPointer, int textLevelEffect, int reversed)
var
int start,
int end,
int textLevel,
int atLeastOneParaSpoken,
int priorLevel,
int priorAlignment,
int index,
object textRange,
int finished
let start=ParaIndexPointer
if not reversed then
	let end=shape.textFrame.textRange.paragraphs.count
else
	let end=1
endIf 
let index=start
let finished=false
let atLeastOneParaSpoken=false
let priorLevel=0
while not finished
	let textRange=shape.textFrame.textRange.paragraphs(index)
	let textLevel=textRange.indentLevel
; skip blank paragraphs
	if textRange.characters.count > 1 then 
; This is a non-blank paragraph
; what we want to do is read from the first para at the specified text level to the next at 
;the same level, not including that one
; ie if we had level 1, level 2, level 2, level 1, 
;then we'd read the first three if the textLevelEffect was set to 1.
; if the textLevelEffect was set to 2 then first call would read para 1, next call would read 
;both paras at level 2, third call would read 4th para at level 1.
;  theoretically, the paragraph index stored in start should already be pointing to the 
;correct paragraph or at least the blank line before it.
; if textLevelEffect is set to ppAnimateByAllLevels then only ever read one bullet point
; now look at outline level
; if animated by all levels, the next test will never be true but will be picked up in the later test
		if textLevel <=textLevelEffect && atLeastOneParaSpoken then
; we have already read a paragraph at the specified level so we should stop as we have 
;found the next one at the same level or at an outdented level
	 		let finished=true
			return
		elif (textLevel >=textLevelEffect) || (textLevelEffect ==ppAnimateByAllLevels) || not atLeastOneParaSpoken then ; >= to take care of first para on first time through loop
; continue reading
			if (getJCFOption(OPT_FORMAT_AND_TEXT)==true && not textOnly) 
		&& (priorLevel  != textRange.indentLevel) then
				sayUsingVoice(VCTX_MESSAGE,msg581+intToString(textRange.indentLevel),ot_status)
				let priorLevel=textRange.indentLevel
			endIf

			if (getJCFOption(OPT_FORMAT_AND_TEXT)==true && not textOnly) 
		&& (priorAlignment!= textRange.paragraphFormat.alignment) then
				sayUsingVoice(VCTX_MESSAGE,getParagraphAlignment(textRange), ot_status)
				let priorAlignment=textRange.paragraphFormat.alignment
			endIf
		
			if textRange.paragraphFormat.bullet.visible then
				say(msg582,ot_string) ; bullet
			endIf
			say(textRange.text,ot_text)
; paragraph pointer is left pointing at last paragraph spoken. It is updated in readSlideShowSlide
			let ParaIndexPointer=index
			let lastParaSpokenIndex=index
			let lastShapeSpokenIndex=globalShapeIndex
		else ; textLevel is less than textLevelEffect parameter 
; will set finished flag but will wait until index is updated before returning
			let finished=true
		endIf ; end of textLevelEffect comparison
		if textLevelEffect==ppAnimateByAllLevels then
; have spoken one paragraph, must return as all levels must be animated separately
			let finished=true
		endIf
		let atLeastOneParaSpoken=true ; flag to indicate that next time we find a paragraph at the initial text level, we should stop
	endIf
	if not reversed then
		if index < end then
			let index=index+1
		else
			let finished=true
		endIf
	else ; reverse
		if index > end then
			let index=index-1
		else
			let finished=true
		endIf
	endIf
endWhile
EndFunction

string Function getShapeTextLevelEffect (object shape)
var
int type
let type=shape.animationSettings.textLevelEffect
if type==ppAnimateByAllLevels then
	return msg602
elif type==ppAnimateByFifthLevel then
	return msg603
elif type==ppAnimateByFirstLevel then
	return msg604
elif type==ppAnimateByFourthLevel then
	return msg605
elif type==ppAnimateBySecondLevel then
	return msg606
elif type==ppAnimateByThirdLevel then
	return msg607
elif type==ppAnimateLevelNone then
	return msg609
elif type < 0 then ;==ppAnimateLevelMixed then
	return msg608
endIf
EndFunction

String Function getAnimationTextUnitEffect (object shape)
var
int effect,
int animationStatus
if !shape then
	return msg600 ; no shape
endIf
let effect=shape.animationSettings.textUnitEffect
let animationStatus=shape.animationSettings.animate
if animationStatus then
	if effect==ppAnimateByCharacter then ;= 2,
		return msg390 ; character
	elif effect==ppAnimateByParagraph then ; = 0,
		return msg392 ; paragraph
	elif effect==ppAnimateByWord then ;= 1,
		return msg391 ; word
	elif effect < 0 then
		return msg393 ; mixed
	endIf
else
	return msg394 ; none
endIf
EndFunction

string Function getShapeAfterEffect (object shape)
var
int effect
let effect=shape.animationSettings.afterEffect
if effect==ppAfterEffectDim then ;= 2,
	return msg370
elif effect==ppAfterEffectHide then ;= 1,
	return msg371
elif effect==ppAfterEffectHideOnClick then ;= 3,
	return msg372
elif effect < 0 then ;;ppAfterEffectMixed = -2, (&HFFFFFFFE)
	return msg373
elif effect==ppAfterEffectNothing then ;= 0
	return msg374
endIf
EndFunction

Void Function sayAnimationInfo (object shape, string voice)
if Shape.animationSettings.advanceMode==ppAdvanceOnClick then
	sayUsingVoice(voice,msg428,ot_message) ; "Advances on mouse click",
elif Shape.animationSettings.advanceMode==ppAdvanceOnTime then 
	sayUsingvoice(voice,msg429,ot_message) ; "Advances on time",
	sayUsingVoice(voice,msg430+inttoString(Shape.animationSettings.advanceTime)+msg431,ot_message)	
endIf
if getVerbosity()==beginner then
	sayUsingvoice(voice,msg397,ot_message) ; shape entry effect
endIf
sayUsingvoice(voice,GetShapeEntryEffect(Shape),ot_message) 
if getVerbosity()==beginner then
	sayUsingvoice(voice,msg398,ot_message) ; text unit
endIf
sayUsingVoice(voice,getAnimationTextUnitEffect(Shape),ot_message)
if getVerbosity()==beginner then
	sayUsingvoice(voice,msg398b,ot_message) ; text level effect
endIf
sayUsingVoice(voice,getShapeTextLevelEffect(Shape),ot_message)
if Shape.animationSettings.AnimateTextInReverse then
	sayUsingVoice(voice,msg398c,ot_message) ; text will be animated in reverse.
endIf
if getVerbosity()==beginner then
	sayUsingVoice(voice,msg398a,ot_message) ; after effect
endIf
sayUsingVoice(voice,getShapeAfterEffect(Shape),ot_message) 
EndFunction

Void Function SayAnimatedShape (object shape, int textOnly, int ByRef startingParaIndex, int textLevelEffect, int reversed)
if not shape.visible() then
  return
endIf
if startingParaIndex ==0 then
; this condition will be true if no paragraphs have appeared due to animation not being triggered
	return
endIf
if GetVerbosity() < advanced && (not TextOnly || shape.hasTable) then
	sayUsingVoice(VCTX_MESSAGE, GetShapeDescription(shape), ot_string)
	sayAnimationInfo(shape,vctx_message) 
	if shape.actionSettings(ppMouseOver).action()==ppActionHyperlink then
		SayUsingVoice(VCTX_MESSAGE, msg50, ot_string) ; link
		SayUsingVoice(VCTX_MESSAGE, getHyperlinkAddress(shape.actionSettings(ppMouseOver).hyperlink(), NoLinkIndex), ot_string)
		if getVerbosity()==beginner then
			SayUsingVoice(VCTX_MESSAGE,msg51, ot_string) ; on mouse over
		endIf
	elif shape.actionSettings(ppMouseClick).action()==ppActionHyperlink then
		SayUsingVoice(VCTX_MESSAGE,msg50, ot_string) ; link
		SayUsingVoice(VCTX_MESSAGE,getHyperlinkAddress(shape.actionSettings(ppMouseClick).hyperlink(), NoLinkIndex), ot_string)
		if getVerbosity()==beginner then
			SayUsingVoice(VCTX_MESSAGE,msg52, ot_string) ; on mouse click
		endIf
	endIf
endIf
if shape.HasTextFrame() then
	if shape.textFrame.hasText() then
		readAnimatedText(shape, textOnly,startingParaIndex,textLevelEffect,reversed)
	endIf
elif shape.alternativeText !="" then
; PP 2000 only
	sayUsingVoice(vctx_message,shape.alternativeText,ot_text)
elif shape.hasTable then
	readTable(shape.table, globalTableReadingMethod)
endIf
EndFunction

Void Function ReadSlideShowSlide (int mode, int textOnly)
var
int index,
int firstIndex,
int lastIndex,
object shapeAnimationSettings,
object slide,
object shape,
int shapeParaCount,
int advanceTime,
int textLevelEffect,
int reversed, ;1 forward, 0 none, -1 backward
int finished

if not isSlideShow() then
	return
endIf
let slide=oPpt.activePresentation.slideShowWindow.view.slide
if globalPriorSlideIndex !=slide.slideIndex then
	if GetVerbosity()==beginner then
		say(msg413a+intToString(slide.slideIndex),ot_message)
	endIf
; read all non-animated shapes first then handle animations
	let firstIndex=1
	let LastIndex=slide.shapes.count
let index=firstIndex
	while index <=lastIndex
		let shape=slide.shapes(index)
		if not shape.AnimationSettings.animate then
; say the shape
			sayShape(shape,textOnly)
		endIf
		let index=index+1
	endWhile
; set up animation tracking globals
	if mode==showAdvance then
		let globalShapeIndex=getFirstAnimatedShapeIndex(slide)
		let globalParaIndexPointer=0
	elif mode==showRetreat then
		let globalShapeIndex=getLastAnimatedShapeIndex(slide)
		let globalParaIndexPointer=slide.shapes(globalShapeIndex).textFrame.textRange.paragraphs.count
	endIf
endIf ; otherwise it is the same slide but triggering animation
; now handle animations

let finished=false
let firstIndex=getFirstAnimatedShapeIndex(slide)
let lastIndex=getLastAnimatedShapeIndex(slide)
while not finished
	let shape=slide.shapes(globalShapeIndex)
	let shapeAnimationSettings=shape.animationSettings
	let reversed=shapeAnimationSettings.AnimateTextInReverse
	let textLevelEffect=shapeAnimationSettings.textLevelEffect
	if shapeAnimationSettings.advanceMode==ppAdvanceOnTime then
		let advanceTime=shapeAnimationSettings.advanceTime*10 ; delay uses 0.1 seconds 
		delay(advanceTime)
		sayAnimatedShape(shape,true,globalParaIndexPointer,textLevelEffect,reversed)		
	elif shapeAnimationSettings.advanceMode==ppAdvanceOnClick then
		sayAnimatedShape(shape,true,globalParaIndexPointer,textLevelEffect,reversed)		
 ; need mouse click to animate next paragraph or group of paragraphs so set finished flag for this time round
		let finished=true
	endIf
; advance/retreat animation tracking pointers
	if mode==showAdvance then
; handle forward animation 
; globalParaIndex is always updated by readAnimatedText to point to last paragraph ;
;spoken
; we update here to point to next one to speak
		if not reversed then
			if globalParaIndexPointer < shape.textFrame.textRange.paragraphs.count then
				let globalParaIndexPointer=globalParaIndexPointer+1
			else
				if globalShapeIndex < lastIndex then
					let globalShapeIndex=getNextAnimatedShapeIndex(shape)
					if not globalShapeIndex then
						let finished=true
					endIf
					let globalParaIndexPointer=0
				else ;flag finished
					let finished=true
					let globalParaIndexPointer=0
				endIf
			endIf
		else ; reversed
; shape is animated in reverse
			if globalParaIndexPointer > 1 then
				let globalParaIndexPointer=globalParaIndexPointer -1
			else
				if globalShapeIndex < lastIndex then
					let globalShapeIndex=getNextAnimatedShapeIndex(shape)
					if not globalShapeIndex then
						let finished=true
					endIf
					let globalParaIndexPointer=0
				else ; flag finished
					let finished=true
					let globalParaIndexPointer=0
				endIf
			endIf
		endIf
	endIf
; currently does not handle retreat.
endWhile 
let globalPriorSlideIndex=slide.slideIndex
EndFunction

Script advanceSlideShow ()
var
int priorSelectionType,
int Typing_echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
If (Typing_Echo != 0) Then
	Say (msgSpace,ot_message)
endIf

let priorSelectionType=oPpt.activeWindow.selection.type ; prior to hitting the spacebar
{space}
; are we in the slide document or show window?
if GetWindowClass(getFocus())!=wc6 then
	return ; we are not
endIf
if isSlideShow() then
	pause()
	readSlideShowSlide(showAdvance,true)
else ; we need to check if we are about to edit a text placeholder on a new slide (activated by spacebar)
	pause() ; let PP do its stuff
; lets see if we have just switched to editing a place holder on a new slide
	if (oPPt.activeWindow.selection.type==ppSelectionText) &&
		(oPpt.activeWindow.selection.type !=priorSelectionType) then
; we've switched to editing 
		say(msg592,ot_message) ; say edit.
	endIf
endIf
EndScript

Script RetreatSlideShow ()
var
int typing_echo
if not isSlideShow() then
	performScript jawsBackspace()
	return
endIf
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
If (Typing_Echo != 0) Then
	Say (msgBackspace,ot_message)
endIf
{backspace}
pause()
readSlideUpToShapeAndPara(getSlideWithFocus(),lastShapeSpokenIndex,lastParaSpokenIndex)
EndScript

Script  SayNextScreen()
var
int oldRestriction
saveCursor()
let oldRestriction=GetJcfOption (OPT_RESTRICT)
{PageDown} ; tell help to do page down
Pause()
	JAWSCursor()
RouteJAWSToPc ()
RestrictCursor (on)
JAWSPageUp ()		
SayAll()
RestrictCursor (oldRestriction)
restoreCursor()
EndScript

Script  SayPriorScreen()
var
int oldRestriction
saveCursor()
let oldRestriction=GetJcfOption (OPT_RESTRICT)
{PageUp} ; tell help to do page down
Pause()
	JAWSCursor()
RouteJAWSToPc ()
RestrictCursor (on)
JAWSPageUp ()		
SayAll()
RestrictCursor (oldRestriction)
restoreCursor()
EndScript

Script  SayAll()
var
object slide

if IsJAWSCursor() || menusActive() || dialogActive() then
	sayToBottom()
elif caretVisible() then
	SayAll()
else
	let slide=GetSlideWithFocus()
	if slide then
		if isSlideShow() then
			readSlideUpToShapeAndPara(slide,lastShapeSpokenIndex,lastParaSpokenIndex)
		else
			readSlide(slide,false,0,0)
		endIf
	else
		performScript sayAll()
	endIf
endIf
EndScript






Script toggleFormatAnnouncement ()
if GetJCFOption (OPT_FORMAT_AND_TEXT) == true then
	SetJcfOption (OPT_FORMAT_AND_TEXT, false)
	Say (msg590, ot_message) ; off
else
	SetJcfOption (OPT_FORMAT_AND_TEXT, true)
	Say (msg591, ot_message) ; on
EndIf
EndScript

Script enterKey ()
var
string focusClass,
int PriorSelectionType, ; before we hit enter
int Typing_echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
If (Typing_Echo != 0) Then
	Say (msgEnter,ot_message)
endIf

let focusClass=getWindowClass(GetFocus())
let priorSelectiontype=oPpt.activeWindow.selection.type
{enter}
pause()
if focusClass==wc6 || focusClass==wc7 then
; check if in edit mode.
	if (oPPt.activeWindow.selection.type==ppSelectionText) &&
		(oPpt.activeWindow.selection.type !=priorSelectionType) then
; we've switched to editing 
		say(msg592,ot_message) ; say edit.
	endIf
endIf
EndScript



Script upALevel ()
var
string focusClass,
int Typing_echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
If (Typing_Echo != 0) Then
	Say (msgEsc,ot_message)
endIf

let focusClass=getWindowClass(GetFocus())
; reset the slide show variables.
let globalParaIndexPointer=0 ; does not point anywhere yet 
let globalShapeIndex=1
let globalPriorSlideIndex=0

if focusClass==wc6 || focusClass==wc7 then
	{escape}
	pause()
; check if at object level
	if oPPt.activeWindow.selection.type==ppSelectionShapes then
		say(msg593,ot_message) ; object level
	endIf
else ; execute the default script
	performScript upALevel() 
endIf
EndScript


Script sayObjectDimentionsAndLocation ()
var
object shape
let shape=oPpt.activeWindow.selection.shapeRange(1)
if !shape then
	say(msg600,ot_help)
	return
endIf
say(getShapeDescription(shape),ot_string)
say(msg596,ot_string) ; top left x =
sayInteger(shape.left)
say(msg597,ot_string) ; top left y
sayInteger(shape.top)
say(msg598,ot_string) ; width =
sayInteger(shape.width)
say(msg599,ot_string) ; height
sayInteger(shape.height)
EndScript

Script sayShapeAnimationInfo ()
var
object selectedShape
let selectedShape=oPpt.activeWindow.selection.shapeRange(1)
if !selectedShape then
	say(msg600,ot_message) ; no shape selected.
	return
endIf
if selectedShape.animationSettings.animate then
	say(msg389,ot_message) ; this shape is animated 
	if selectedShape.animationSettings.advanceMode==ppAdvanceOnClick then
		say(msg428,ot_message) ; "Advances on mouse click",
	elif selectedShape.animationSettings.advanceMode==ppAdvanceOnTime then 
		say(msg429,ot_message) ; "Advances on time",
		say(msg430+inttoString(selectedShape.animationSettings.advanceTime)+msg431,ot_message)	
	endIf
	if getVerbosity()==beginner then
		say(msg397,ot_message) ; shape entry effect
	endIf
	say(GetShapeEntryEffect(selectedShape),ot_message) 
	if getVerbosity()==beginner then
		say(msg398,ot_message) ; text unit
	endIf
	say(getAnimationTextUnitEffect(selectedShape),ot_message)
	if getVerbosity()==beginner then
		say(msg398b,ot_message) ; text level effect
	endIf
	say(getShapeTextLevelEffect(selectedShape),ot_message)
	if selectedShape.animationSettings.AnimateTextInReverse then
		say(msg398c,ot_message) ; text will be animated in reverse.
	endIf
	if getVerbosity()==beginner then
		say(msg398a,ot_message) ; after effect
	endIf
	say(getShapeAfterEffect(selectedShape),ot_message) 
else
	say(msg396,ot_message) ; this shape is not animated

endIf
EndScript


Script SwitchPanes ()
{f6}
pause() ; let PP change views
; wc6 is the main slide window, ie "PaneClassDC"
if GetWindowClass(GetFocus())==wc6 && oPpt.activeWindow.viewType==ppViewNormal then
	sayActivePaneView()
endIf
EndScript
